<!DOCTYPE html>


<html>
<head>
    <meta charset="utf-8">
    <title>Invoice</title>
    <link rel="stylesheet" href="public/assets/style.css">

    <script>
        window.print();
    </script>

</head>
<body>
<header>
    <h1>Invoice</h1>
    <address contenteditable>
        <p style="font-weight: bold"><b><?php echo($customer->username); ?></b></p>
        <p><?php echo($customer->name); ?></p>
        <p><?php echo($customer->email); ?></p>
        <p><?php echo($customer->phone); ?></p>
    </address>
    <span><img alt="" src="public/assets/img/logo.png" style="height: 70px"><input type="file" accept="image/*"></span>
</header>
<article>


    <table class="meta">
        <tr>
            <th><span contenteditable>Order #</span></th>
            <td><span contenteditable><?php echo($order->order_id); ?></span></td>
        </tr>
        <tr>
            <th><span contenteditable>Date</span></th>
            <td><span contenteditable><?php echo(date('d-m-Y',strtotime($order->date))); ?> <?php echo(date('h:i A',strtotime($order->date))); ?></span></td>
        </tr>
        <tr>
            <th><span contenteditable>Total Amount</span></th>
            <td><span id="" contenteditable>$</span><span><?php echo($order->total*$order->qty); ?></span></td>
        </tr>
    </table>
    <table class="inventory">
        <thead>
        <tr>
            <th><span contenteditable>Item</span></th>

            <th><span contenteditable>Rate</span></th>
            <th><span contenteditable>Quantity</span></th>

            <th><span contenteditable>Price</span></th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td style="text-align: center"><span contenteditable ><?php echo($order->product); ?></span></td>

            <td style="text-align: center"><span data-prefix>$</span><span contenteditable><?php  echo($order->amount); ?></span></td>
            <td style="text-align: center"><span contenteditable><?php echo($order->qty); ?></span></td>
            <td><span data-prefix>$</span><span><?php  echo($order->amount*$order->qty); ?></span></td>
        </tr>
        </tbody>
    </table>

    <table class="balance">
        <tr>
            <th><span contenteditable>Total</span></th>
            <td><span data-prefix>$</span><span><?php  echo($order->amount*$order->qty); ?></span></td>
        </tr>
        <tr>
            <th><span contenteditable>GST</span></th>
            <td><span data-prefix></span><span contenteditable><?php  echo($order->gst); ?>%</span></td>
        </tr>
        <tr>
            <th><span contenteditable>Total Amount</span></th>
            <td><span data-prefix>$</span><span><?php  echo($order->total*$order->qty); ?></span></td>
        </tr>
    </table>
</article>
<aside>
    <h1><span contenteditable></span></h1>
    <div contenteditable>
        <p>This Is Computer Generated Invoice, Does Not Require Signature.</p>
    </div>
</aside>
</body>
</html>



<script>
    window.close();
</script>