<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<title>Products</title>

	<meta name="keywords" content="" />
	<meta name="description" content="">
	<meta name="author" content="">

	<!-- Favicon -->
	<link rel="icon" type="image/x-icon" href="website/assets/images/icons/favicon.ico">

	<script type="text/javascript">
		WebFontConfig = {
			google: { families: [ 'Open+Sans:300,400,600,700,800','Poppins:300,400,500,600,700,800' ] }
		};
		(function(d) {
			var wf = d.createElement('script'), s = d.scripts[0];
			wf.src = 'website/assets/js/webfont.js';
			wf.async = true;
			s.parentNode.insertBefore(wf, s);
		})(document);
	</script>

	<!-- Plugins CSS File -->
	<link rel="stylesheet" href="website/assets/css/bootstrap.min.css">

	<!-- Main CSS File -->
	<link rel="stylesheet" href="website/assets/css/style.min.css">
	<link rel="stylesheet" type="text/css" href="website/assets/vendor/fontawesome-free/css/all.min.css">
</head>
<body>
	<div class="page-wrapper">
		
		
<?php
include(app_path().'/views/website-header.php');
?>


	<main class="main">
			<nav aria-label="breadcrumb" class="breadcrumb-nav">
				<div class="container">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="index"><i class="icon-home"></i></a></li>
						<li class="breadcrumb-item active" aria-current="page">Products</li>
					</ol>
				</div>
			</nav>




			

			<div class="container pb-3">
				
				
				<div class="row mx-0 divide-line up-effect">
			


									<?php
									foreach($legal as $pr){
									?>

						<div class="col-6 col-sm-4 col-md-3 col-xl-5col">
								<div class="product-default inner-quickview inner-icon">
									<figure>
										<a href="product-detail?id=<?php  echo($pr->id);  ?>">
											<img src="public/product-image/<?php  echo($pr->image); ?>">
											<?php
											if($pr->image1!="0"){
											?>
											<img src="public/product-image/<?php  echo($pr->image1); ?>">
											<?php
											}else{
											?>
											
											<img src="public/product-image/<?php  echo($pr->image); ?>">
											
											<?php
											}
											?>
										</a>
										<div class="label-group">
											<span class="product-label label-sale">-<?php  number_format((float)$pr->discount, 0, '.', ''); ?>%</span>
										</div>
										
										
										<a href="product-detail?id=<?php  echo($pr->id);  ?>" class="btn-quickview1" title="Quick View">Quick View</a>
									</figure>
									<div class="product-details">
										<div class="category-wrap">
											<div class="category-list">
												<a href="#" class="product-category"><?php  echo($pr->category);  ?></a>
											</div>
											<a href="#" class="btn-icon-wish"><i class="icon-heart"></i></a>
										</div>
										<h3 class="product-title">
											<a href="product-detail?id=<?php  echo($pr->id);  ?>"><?php  echo($pr->name);  ?></a>
										</h3>
										<div class="ratings-container">
											<div class="product-ratings">
												<span class="ratings" style="width:100%"></span><!-- End .ratings -->
												<span class="tooltiptext tooltip-top"></span>
											</div><!-- End .product-ratings -->
										</div><!-- End .product-container -->
										<div class="price-box">
											<span class="old-price">&#8377;<?php   echo number_format((float)$pr->mrp, 2, '.', ''); ?></span>
											<span class="product-price">&#8377;<?php echo number_format((float)$pr->mrp, 2, '.', ''); ?></span>
										</div><!-- End .price-box -->
									</div><!-- End .product-details -->
								</div>
							</div><!-- End .col-xl-5col -->

						
								
									<?php
									}
									?>
						
						




				</div><!-- End .row -->

			
			
			
			
			</div><!-- End .container -->
	

			<div  style="display:none;"class="container mb-8">
				<div id="map"></div><!-- End #map -->

				<div class="row">
					<div class="col-md-8">
						<h2 class="light-title">Write <strong>Us</strong></h2>

						<form action="#">
							<div class="form-group required-field">
								<label for="contact-name">Name</label>
								<input type="text" class="form-control" id="contact-name" name="contact-name" required>
							</div><!-- End .form-group -->

							<div class="form-group required-field">
								<label for="contact-email">Email</label>
								<input type="email" class="form-control" id="contact-email" name="contact-email" required>
							</div><!-- End .form-group -->

							<div class="form-group">
								<label for="contact-phone">Phone Number</label>
								<input type="tel" class="form-control" id="contact-phone" name="contact-phone">
							</div><!-- End .form-group -->

							<div class="form-group required-field">
								<label for="contact-message">What’s on your mind?</label>
								<textarea cols="30" rows="1" id="contact-message" class="form-control" name="contact-message" required></textarea>
							</div><!-- End .form-group -->

							<div class="form-footer">
								<button type="submit" class="btn btn-primary">Submit</button>
							</div><!-- End .form-footer -->
						</form>
					</div><!-- End .col-md-8 -->

					<div class="col-md-4">
						<h2 class="light-title">Contact <strong>Details</strong></h2>

						<div class="contact-info">
							<div>
								<i class="icon-phone"></i>
								<p><a href="tel:">0201 203 2032</a></p>
								<p><a href="tel:">0201 203 2032</a></p>
							</div>
							<div>
								<i class="icon-mobile"></i>
								<p><a href="tel:">201-123-3922</a></p>
								<p><a href="tel:">302-123-3928</a></p>
							</div>
							<div>
								<i class="icon-mail-alt"></i>
								<p><a href="mailto:#">porto@gmail.com</a></p>
								<p><a href="mailto:#">porto@portotemplate.com</a></p>
							</div>
							<div>
								<i class="icon-skype"></i>
								<p>porto_skype</p>
								<p>porto_template</p>
							</div>
						</div><!-- End .contact-info -->
					</div><!-- End .col-md-4 -->
				</div><!-- End .row -->
			</div><!-- End .container -->
		</main><!-- End .main -->


<?php
include(app_path().'/views/website-footer.php');
?>




</div><!-- End .page-wrapper -->

<?php
include(app_path().'/views/website-footer2.php');
?>
	<!-- Plugins JS File -->
	<script src="website/assets/js/jquery.min.js"></script>
	<script src="website/assets/js/bootstrap.bundle.min.js"></script>
	<script src="website/assets/js/plugins.min.js"></script>

	<!-- Main JS File -->
	<script src="website/assets/js/main.min.js"></script>
</body>

</html>