<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<title>Products</title>

  <meta property="og:title" content="<?php  echo($pro->name);  ?>">
<meta property="og:image" content="https://www.cryptoindexpool.live/public/product-image/<?php  echo($pro->image);  ?>">


	<!-- Favicon -->
	<link rel="icon" type="image/x-icon" href="website/assets/images/icons/favicon.ico">

	<script type="text/javascript">
		WebFontConfig = {
			google: { families: [ 'Open+Sans:300,400,600,700,800','Poppins:300,400,500,600,700,800' ] }
		};
		(function(d) {
			var wf = d.createElement('script'), s = d.scripts[0];
			wf.src = 'website/assets/js/webfont.js';
			wf.async = true;
			s.parentNode.insertBefore(wf, s);
		})(document);
	</script>

	<!-- Plugins CSS File -->
	<link rel="stylesheet" href="website/assets/css/bootstrap.min.css">

	<!-- Main CSS File -->
	<link rel="stylesheet" href="website/assets/css/style.min.css">
	<link rel="stylesheet" type="text/css" href="website/assets/vendor/fontawesome-free/css/all.min.css">
</head>
<body>
	<div class="page-wrapper">
		
		
<?php
include(app_path().'/views/website-header.php');
?>


	<main class="main">
			<nav aria-label="breadcrumb" class="breadcrumb-nav">
				<div class="container">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="index"><i class="icon-home"></i></a></li>
						<li class="breadcrumb-item active" aria-current="page">Products</li>
					</ol>
				</div>
			</nav>




			
	<div class="container">
				<div class="product-single-container product-single-default">
					<div class="row">
						<div class="col-md-5 product-single-gallery">
							<div class="product-slider-container">
								<div class="product-single-carousel owl-carousel owl-theme">
									<div class="product-item">
										<img class="product-single-image" src="public/product-image/<?php  echo($pro->image);  ?>" data-zoom-image="public/product-image/<?php  echo($pro->image);  ?>"/>
									</div>
									<?php
									if($pro->image1!="0"){
									?>
									<div class="product-item">
										<img class="product-single-image" src="public/product-image/<?php  echo($pro->image1);  ?>" data-zoom-image="public/product-image/<?php  echo($pro->image1);  ?>"/>
									</div>
									<?php
									}
									if($pro->image2!="0"){
									?>
									<div class="product-item">
										<img class="product-single-image" src="public/product-image/<?php  echo($pro->image2);  ?>" data-zoom-image="public/product-image/<?php  echo($pro->image2);  ?>"/>
									</div>
									<?php
									}
									if($pro->image3!="0"){
									?>
									<div class="product-item">
										<img class="product-single-image" src="public/product-image/<?php  echo($pro->image3);  ?>" data-zoom-image="public/product-image/<?php  echo($pro->image3);  ?>"/>
									</div>
									<?php
									}
									?>
								</div>
								<!-- End .product-single-carousel -->
								<span class="prod-full-screen">
									<i class="icon-plus"></i>
								</span>
							</div>
							<div class="prod-thumbnail owl-dots" id='carousel-custom-dots'>
								<div class="owl-dot">
									<img src="public/product-image/<?php  echo($pro->image);  ?>" style="height:120px;width:auto;"/>
								</div>
									<?php
									
									if($pro->image1!="0"){
									?>
								<div class="owl-dot">
									<img src="public/product-image/<?php  echo($pro->image1);  ?>" style="height:120px;width:auto;"/>
								</div>
									<?php
									}
									if($pro->image2!="0"){
									?>
								<div class="owl-dot">
									<img src="public/product-image/<?php  echo($pro->image2);  ?>" style="height:120px;width:auto;"/>
								</div>
									<?php
									}
									if($pro->image3!="0"){
									?>
								<div class="owl-dot">
									<img src="public/product-image/<?php  echo($pro->image3);  ?>" style="height:120px;width:auto;"/>
								</div>
									<?php
									}
									
									?>
							</div>
						</div><!-- End .product-single-gallery -->

						<div class="col-md-7 product-single-details">
							<h1 class="product-title"><?php  echo($pro->name);  ?></h1>

							<div class="ratings-container">
								<div class="product-ratings">
									<span class="ratings" style="width:100%"></span><!-- End .ratings -->
								</div><!-- End .product-ratings -->

							
							</div><!-- End .ratings-container -->

							<hr class="short-divider">

							<div class="price-box">
							<span class="old-price">&#8377;<?php  echo($pro->mrp);  ?></span>
								<span class="product-price">&#8377;<?php  echo($pro->mrp);  ?></span>
							</div><!-- End .price-box -->

							<div class="product-desc">
								<p>
								<?php  echo($pro->description);  ?>
								</p>
							</div><!-- End .product-desc -->

					
					

							<hr class="divider">

							<div class="product-action">
								<div class="product-single-qty">
									<input class="horizontal-quantity form-control" type="text">
								</div><!-- End .product-single-qty -->

								<a href="login" class="btn btn-dark add-cart icon-shopping-cart" title="Add to Cart">Add to Cart</a>
							</div><!-- End .product-action -->

							<hr class="divider mb-1">

							<div style="" class="product-single-share">
								<label class="sr-only">Share:</label>

								<div class="social-icons mr-2">
								<h3>Share :</h3> 
									<a href="https://www.facebook.com/share.php?u=https://www.cryptoindexpool.live/product-detail?id=<?php  echo($pro->id);  ?>" class="social-icon" target="_blank" title="Facebook">
									
									<img src="fac.png">
									
									</a>
									<a href="https://wa.me/?text=https://www.cryptoindexpool.live/product-detail?id=<?php  echo($pro->id);  ?> Product : <?php  echo($pro->name);  ?> Price : <?php  echo($pro->mrp);  ?> Description : <?php  echo($pro->description);  ?>" class="social-icon" target="_blank" title="WhatsApp">
									
									<img src="wha.png">
									
									</a>
									
									
								</div><!-- End .social-icons -->


							</div><!-- End .product single-share -->
						</div><!-- End .product-single-details -->
					</div><!-- End .row -->
				</div><!-- End .product-single-container -->

				<div class="product-single-tabs">
					<ul class="nav nav-tabs" role="tablist">
						<li class="nav-item">
							<a class="nav-link active" id="product-tab-desc" data-toggle="tab" href="#product-desc-content" role="tab" aria-controls="product-desc-content" aria-selected="true">Description</a>
						</li>
					
					
					</ul>
					<div class="tab-content">
						<div class="tab-pane fade show active" id="product-desc-content" role="tabpanel" aria-labelledby="product-tab-desc">
							<div class="product-desc-content">
								<p><?php  echo($pro->description);  ?></p>
								
								</div><!-- End .product-desc-content -->
						</div><!-- End .tab-pane -->

						<div class="tab-pane fade fade" id="product-more-info-content" role="tabpanel" aria-labelledby="product-tab-more-info">
							<div class="product-desc-content">
								<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat.</p>
							</div><!-- End .product-desc-content -->
						</div><!-- End .tab-pane -->

						<div class="tab-pane fade" id="product-tags-content" role="tabpanel" aria-labelledby="product-tab-tags">
							<div class="product-tags-content">
								<form action="#">
									<h4>Add Your Tags:</h4>
									<div class="form-group">
										<input type="text" class="form-control form-control-sm" required>
										<input type="submit" class="btn btn-dark" value="Add Tags">
									</div><!-- End .form-group -->
								</form>
								<p class="note">Use spaces to separate tags. Use single quotes (') for phrases.</p>
							</div><!-- End .product-tags-content -->
						</div><!-- End .tab-pane -->

						<div class="tab-pane fade" id="product-reviews-content" role="tabpanel" aria-labelledby="product-tab-reviews">
							<div class="product-reviews-content">
								<div class="row">
									<div class="col-xl-7">
										<h2 class="reviews-title">3 reviews for Product Long Name</h2>

										<ol class="comment-list">
											<li class="comment-container">
												<div class="comment-avatar">
													<img src="assets/images/avatar/avatar1.jpg" width="65" height="65" alt="avatar"/>
												</div><!-- End .comment-avatar-->

												<div class="comment-box">
													<div class="ratings-container">
														<div class="product-ratings">
															<span class="ratings" style="width:80%"></span><!-- End .ratings -->
														</div><!-- End .product-ratings -->
													</div><!-- End .ratings-container -->

													<div class="comment-info mb-1">
														<h4 class="avatar-name">John Doe</h4> - <span class="comment-date">Novemeber 15, 2019</span>
													</div><!-- End .comment-info -->

													<div class="comment-text">
														<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.</p>
													</div><!-- End .comment-text -->
												</div><!-- End .comment-box -->
											</li><!-- comment-container -->

											<li class="comment-container">
												<div class="comment-avatar">
													<img src="assets/images/avatar/avatar2.jpg" width="65" height="65" alt="avatar"/>
												</div><!-- End .comment-avatar-->

												<div class="comment-box">
													<div class="ratings-container">
														<div class="product-ratings">
															<span class="ratings" style="width:80%"></span><!-- End .ratings -->
														</div><!-- End .product-ratings -->
													</div><!-- End .ratings-container -->

													<div class="comment-info mb-1">
														<h4 class="avatar-name">John Doe</h4> - <span class="comment-date">Novemeber 15, 2019</span>
													</div><!-- End .comment-info -->

													<div class="comment-text">
														<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.</p>
													</div><!-- End .comment-text -->
												</div><!-- End .comment-box -->
											</li><!-- comment-container -->

											<li class="comment-container">
												<div class="comment-avatar">
													<img src="assets/images/avatar/avatar3.jpg" width="65" height="65" alt="avatar"/>
												</div><!-- End .comment-avatar-->

												<div class="comment-box">
													<div class="ratings-container">
														<div class="product-ratings">
															<span class="ratings" style="width:80%"></span><!-- End .ratings -->
														</div><!-- End .product-ratings -->
													</div><!-- End .ratings-container -->

													<div class="comment-info mb-1">
														<h4 class="avatar-name">John Doe</h4> - <span class="comment-date">Novemeber 15, 2019</span>
													</div><!-- End .comment-info -->

													<div class="comment-text">
														<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip.</p>
													</div><!-- End .comment-text -->
												</div><!-- End .comment-box -->
											</li><!-- comment-container -->
										</ol><!-- End .comment-list -->
									</div>

									<div class="col-xl-5">
										<div class="add-product-review">
											<form action="#" class="comment-form m-0">
												<h3 class="review-title">Add a Review</h3>

												<div class="rating-form">
													<label for="rating">Your rating</label>
													<span class="rating-stars">
														<a class="star-1" href="#">1</a>
														<a class="star-2" href="#">2</a>
														<a class="star-3" href="#">3</a>
														<a class="star-4" href="#">4</a>
														<a class="star-5" href="#">5</a>
													</span>

													<select name="rating" id="rating" required="" style="display: none;">
														<option value="">Rate…</option>
														<option value="5">Perfect</option>
														<option value="4">Good</option>
														<option value="3">Average</option>
														<option value="2">Not that bad</option>
														<option value="1">Very poor</option>
													</select>
												</div>

												<div class="form-group">
													<label>Your Review</label>
													<textarea cols="5" rows="6" class="form-control form-control-sm"></textarea>
												</div><!-- End .form-group -->

												<div class="row">
													<div class="col-md-6 col-xl-12">
														<div class="form-group">
															<label>Your Name</label>
															<input type="text" class="form-control form-control-sm" required>
														</div><!-- End .form-group -->
													</div>

													<div class="col-md-6 col-xl-12">
														<div class="form-group">
															<label>Your E-mail</label>
															<input type="text" class="form-control form-control-sm" required>
														</div><!-- End .form-group -->
													</div>
												</div>

												<input type="submit" class="btn btn-dark ls-n-15" value="Submit">
											</form>
										</div><!-- End .add-product-review -->
									</div>
								</div>
							</div><!-- End .product-reviews-content -->
						</div><!-- End .tab-pane -->
					</div><!-- End .tab-content -->
				</div><!-- End .product-single-tabs -->

				<div class="products-section pt-0">
					<h2 class="section-title">Related Products</h2>

					<div class="products-slider owl-carousel owl-theme dots-top">
					


									<?php
									foreach($legal as $pr){
									?>
					<div class="product-default inner-quickview inner-icon">
							<figure>
								<a href="product-detail?id=<?php  echo($pr->id);  ?>">
									<img src="public/product-image/<?php  echo($pr->image); ?>">
								</a>
								<div class="label-group">
									<span class="product-label label-sale">-<?php  number_format((float)$pr->discount, 0, '.', ''); ?>%</span>
								</div>
								
										<a href="product-detail?id=<?php  echo($pr->id);  ?>" class="btn-quickview1" title="Quick View">Quick View</a>
									
									
									</figure>
							<div class="product-details">
								<div class="category-wrap">
									<div class="category-list">
										<a href="product-detail?id=<?php  echo($pr->id);  ?>" class="product-category"><?php  echo($pr->category);  ?></a>
									</div>
								</div>
								<h3 class="product-title">
									<a href="product-detail?id=<?php  echo($pr->id);  ?>"><?php  echo($pr->name);  ?></a>
								</h3>
								<div class="ratings-container">
									<div class="product-ratings">
										<span class="ratings" style="width:100%"></span><!-- End .ratings -->
										<span class="tooltiptext tooltip-top"></span>
									</div><!-- End .product-ratings -->
								</div><!-- End .ratings-container -->
								<div class="price-box">
									<span class="old-price">&#8377;<?php   echo number_format((float)$pr->mrp, 2, '.', ''); ?></span>
											<span class="product-price">&#8377;<?php echo number_format((float)$pr->mrp, 2, '.', ''); ?></span>
									
									
									</div><!-- End .price-box -->
							</div><!-- End .product-details -->
						</div>
					


									<?php
									}
									?>

					</div><!-- End .products-slider -->
				</div><!-- End .products-section -->
			</div><!-- End .container -->
		

			<div  style="display:none;"class="container mb-8">
				<div id="map"></div><!-- End #map -->

				<div class="row">
					<div class="col-md-8">
						<h2 class="light-title">Write <strong>Us</strong></h2>

						<form action="#">
							<div class="form-group required-field">
								<label for="contact-name">Name</label>
								<input type="text" class="form-control" id="contact-name" name="contact-name" required>
							</div><!-- End .form-group -->

							<div class="form-group required-field">
								<label for="contact-email">Email</label>
								<input type="email" class="form-control" id="contact-email" name="contact-email" required>
							</div><!-- End .form-group -->

							<div class="form-group">
								<label for="contact-phone">Phone Number</label>
								<input type="tel" class="form-control" id="contact-phone" name="contact-phone">
							</div><!-- End .form-group -->

							<div class="form-group required-field">
								<label for="contact-message">What’s on your mind?</label>
								<textarea cols="30" rows="1" id="contact-message" class="form-control" name="contact-message" required></textarea>
							</div><!-- End .form-group -->

							<div class="form-footer">
								<button type="submit" class="btn btn-primary">Submit</button>
							</div><!-- End .form-footer -->
						</form>
					</div><!-- End .col-md-8 -->

					<div class="col-md-4">
						<h2 class="light-title">Contact <strong>Details</strong></h2>

						<div class="contact-info">
							<div>
								<i class="icon-phone"></i>
								<p><a href="tel:">0201 203 2032</a></p>
								<p><a href="tel:">0201 203 2032</a></p>
							</div>
							<div>
								<i class="icon-mobile"></i>
								<p><a href="tel:">201-123-3922</a></p>
								<p><a href="tel:">302-123-3928</a></p>
							</div>
							<div>
								<i class="icon-mail-alt"></i>
								<p><a href="mailto:#">porto@gmail.com</a></p>
								<p><a href="mailto:#">porto@portotemplate.com</a></p>
							</div>
							<div>
								<i class="icon-skype"></i>
								<p>porto_skype</p>
								<p>porto_template</p>
							</div>
						</div><!-- End .contact-info -->
					</div><!-- End .col-md-4 -->
				</div><!-- End .row -->
			</div><!-- End .container -->
		</main><!-- End .main -->


<?php
include(app_path().'/views/website-footer.php');
?>




</div><!-- End .page-wrapper -->

<?php
include(app_path().'/views/website-footer2.php');
?>
	<!-- Plugins JS File -->
	<script src="website/assets/js/jquery.min.js"></script>
	<script src="website/assets/js/bootstrap.bundle.min.js"></script>
	<script src="website/assets/js/plugins.min.js"></script>

	<!-- Main JS File -->
	<script src="website/assets/js/main.min.js"></script>
</body>

</html>