<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CIP Token Contract Migration Notification</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 900px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 {
            color: #2c3e50;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }
        h2 {
            color: #2980b9;
            margin-top: 30px;
        }
        .highlight {
            background-color: #f8f9fa;
            padding: 15px;
            border-left: 4px solid #3498db;
            margin: 20px 0;
            font-family: monospace;
            word-break: break-all;
        }
        .feature-box {
            background-color: #e8f4fc;
            border-radius: 5px;
            padding: 15px;
            margin: 20px 0;
        }
        .important {
            background-color: #fff3cd;
            padding: 15px;
            border-left: 4px solid #ffc107;
            margin: 20px 0;
        }
        .steps {
            background-color: #e2f3e2;
            padding: 15px 15px 15px 30px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .swap-portal {
            background-color: #e6f7ff;
            padding: 20px;
            border-radius: 5px;
            margin: 25px 0;
            border: 1px solid #91d5ff;
            text-align: center;
        }
        .swap-link {
            display: inline-block;
            background-color: #1890ff;
            color: white;
            padding: 10px 20px;
            border-radius: 4px;
            text-decoration: none;
            font-weight: bold;
            margin-top: 10px;
        }
        .swap-link:hover {
            background-color: #096dd9;
        }
        .footer {
            margin-top: 40px;
            font-size: 0.9em;
            color: #7f8c8d;
            border-top: 1px solid #eee;
            padding-top: 20px;
        }
    </style>
</head>
<body>
    <h1>Important Announcement: CIP Token Contract Migration</h1>
    
    <div class="important">
        <p><strong>Attention all CIP Token holders:</strong> We have successfully migrated to a new smart contract address. This upgrade brings significant improvements to our token's security, functionality, and decentralization.</p>
    </div>
    
    <h2>Contract Address Details</h2>
    <p><strong>Previous Contract (Deprecated):</strong></p>
    <div class="highlight">0xd7a892f28dEdC74E6b7b33F93BE08abfC394a360</div>
    
    <p><strong>New Contract (Active):</strong></p>
    <div class="highlight">0xe8309a1d00aE006f671A8743a0835bDe092Ac023</div>
    
    <div class="swap-portal">
        <h3>Token Swap Portal</h3>
        <p>All current holders can swap their old tokens for new tokens at our official swap portal:</p>
        <a href="#" class="swap-link" id="swapp" onclick="alert('Start Soon')">Swap Your Tokens Now</a>
        <p>Exchange rate: 1 old CIP = 1 new CIP</p>
        <p><small>The swap portal will be available until April 28, 2025 08:00 AM UTC</small></p>
    </div>
    
    <h2>Why We Migrated to a New Contract</h2>
    
    <div class="feature-box">
        <h3>1. Full Decentralization</h3>
        <p>The most significant change is that we've renounced ownership of the new contract completely. Unlike the previous contract which had an owner address with special privileges, the new contract is entirely decentralized with no admin controls. This means:</p>
        <ul>
            <li>No one can pause trading</li>
            <li>No one can mint new tokens</li>
            <li>No one can modify transaction fees</li>
            <li>The contract is truly immutable</li>
        </ul>
    </div>
    
    <div class="feature-box">
        <h3>2. Enhanced Security Features</h3>
        <p>The new contract includes several security improvements:</p>
        <ul>
            <li>Improved protection against potential reentrancy attacks</li>
            <li>Better input validation to prevent edge cases</li>
            <li>Optimized gas usage for common operations</li>
            <li>Removed all upgradeability functions to prevent future changes</li>
        </ul>
    </div>
    
    <div class="feature-box">
        <h3>3. Future-Proof Tokenomics</h3>
        <p>The migration allows us to implement a more sustainable token model:</p>
        <ul>
            <li>Fixed maximum supply that cannot be altered</li>
            <li>No hidden minting functions</li>
            <li>Transparent fee structure (if applicable)</li>
            <li>Better compatibility with DeFi platforms and exchanges</li>
        </ul>
    </div>
    
    <div class="feature-box">
        <h3>4. Improved Compliance</h3>
        <p>The new contract adheres to the latest standards and best practices:</p>
        <ul>
            <li>Full ERC-20 compliance with all required functions</li>
            <li>Better event logging for transparency</li>
            <li>Clearer function documentation in the code</li>
            <li>Removed any potentially problematic functions from the previous contract</li>
        </ul>
    </div>
    
    <h2>What This Means for You</h2>
    
    <div class="steps">
        <h3>For Existing Holders:</h3>
        <p>You can swap your old tokens for new tokens at our official swap portal. The process is simple:</p>
        <ol>
            <li>Connect your wallet to the swap portal</li>
            <li>Approve the token swap</li>
            <li>Confirm the transaction</li>
            <li>Receive your new CIP tokens instantly</li>
        </ol>
        <p>The swap maintains your exact token balance (1:1 ratio).</p>
    </div>
    
    <div class="steps">
        <h3>For New Purchases:</h3>
        <p>Always ensure you're using the new contract address when buying CIP tokens. The old contract is deprecated and tokens there will not be supported moving forward.</p>
    </div>
    
    <div class="steps">
        <h3>For Exchanges and Liquidity Providers:</h3>
        <p>Please update your systems to use the new contract address. The old contract will no longer receive updates or support.</p>
    </div>
    
    <h2>Verification Details</h2>
    <p>The new contract has been verified on Etherscan and all major blockchain explorers. You can verify:</p>
    <ul>
        <li>That ownership has been renounced (check the "Contract" tab on Etherscan)</li>
        <li>That the total supply matches the previous contract</li>
        <li>That all token balances were correctly migrated</li>
    </ul>
    
    <h2>Frequently Asked Questions</h2>
    
    <p><strong>Q: How do I swap my old tokens for new ones?</strong><br>
    A: Visit our official swap portal at <a href="https://www.cryptoindexpool.live/swapCIP" target="_blank">www.cryptoindexpool.live/swapCIP</a> and follow the simple steps to exchange your tokens at a 1:1 ratio.</p>
    
    <p><strong>Q: Is there a deadline to swap my tokens?</strong><br>
    A: The swap portal will remain available until April 28, 2025 08:00 AM UTC. We recommend swapping as soon as possible.</p>
    
    <p><strong>Q: Why did you renounce ownership?</strong><br>
    A: To provide complete transparency and decentralization, ensuring no single party can alter the token's fundamental properties.</p>
    
    <p><strong>Q: How can I be sure the new contract is safe?</strong><br>
    A: The contract code is fully verified and available for public review. We also recommend checking community feedback and audit reports.</p>
    
    <p><strong>Q: Will this affect my token's value?</strong><br>
    A: The migration itself doesn't affect token value - it's the same asset with improved technology. The increased decentralization may be viewed positively by the market.</p>
    
    <p><strong>Q: Where can I get more help?</strong><br>
    A: Contact our official support channels listed on our website. Beware of scammers - we will never DM you first.</p>
    
    <div class="important">
        <p><strong>Reminder:</strong> Always double-check contract addresses when transacting. Beware of fake tokens and scams impersonating our migration. Only use our official swap portal for token migration.</p>
    </div>
     
    <div class="footer">
        <p>This announcement was published on April 20, 2025. Please check our official channels for the most current information.</p>
        <p>© 2025 CIP Token Project. All rights reserved.</p>
    </div>
</body>
</html>