





<!DOCTYPE html>
<html lang="en" data-bs-theme="dark" class="bg-cover-2">
<head>
<meta charset="utf-8">
<title>Crypto Index Pool | Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<meta name="description" content>
<meta name="author" content>

<link href="admins/assets/css/vendor.min.css" rel="stylesheet">
<link href="admins/assets/css/app.min.css" rel="stylesheet">
<link rel="shortcut icon" type="image/png" href="public/img/news/<?php echo($logo->image);?>">

<style>
  /* Your existing styles... */
  
  /* Add these new styles */
  #location-permission {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    height: 100vh;
    text-align: center;
    padding: 20px;
  }
  
  #location-permission h2 {
    margin-bottom: 20px;
  }
  
  #location-permission button {
    margin-top: 20px;
    padding: 10px 30px;
  }
  
  #login-content {
    display: none; /* Hidden by default until location is allowed */
  }
  
  .location-error {
    color: #ff6b6b;
    margin-top: 15px;
  }
</style>
</head>


  <div class="popup-overlay" id="popup" style="">
  <div class="popup-box">
    <button class="close-btn" onclick="document.getElementById('popup').style.display='none';">&times;</button>
    <h2>Website is under maintenance, Will be resume shortly...</h2>
  </div>
</div>

<script>
  window.onload = function() {
    document.getElementById('popup').style.display = 'flex';
  };
</script>



<body class="theme-success">

<div id="app" class="app app-full-height app-without-header">

<!-- Location Permission Request Section (Shown First) -->
<div id="location-permission" class="okok">
    <a href="index"><img src="public/img/news/<?php echo($logo->image);?>" style="height:70px"></a>
    <h2>We Need Your Location</h2>
    <p>To provide you with the best experience, we need to know your country and state.</p>
    <p>Please allow location access to continue to the login page.</p>
    <button id="allow-location-btn" class="btn btn-outline-theme btn-lg">Allow Location</button>
    <div id="location-error" class="location-error"></div>
</div>

<!-- Your Existing Login Content (Hidden Initially) -->
<div id="login-content" class="login">
   
   
   
   
   
   <div class="login-content okok" style="text-align:center;padding:25px">

    <a href="index"><img src="public/img/news/<?php echo($logo->image);?>" style="height:70px"></a>
    
<h1 class="text-center">Login</h1>

<br>



<form method="post" id="login-form">
				   
				   <input type="hidden" name="ref" id="ref" value="0">
				   
				   
				   <input type="hidden" name="location" id="locc" >
				   
                                       <div class="swap-input-box">
                                         
                                          <div class="swap-input-main">
                                           
                            <input type="text" class="form-control inp" name="email" id="email" placeholder="Login ID">
                            <br>
                            
                             <input type="password" name="password" id="login_password" class="form-control inp" placeholder="Password">
                             <br>
                                          </div>
                                       </div>
                                       
                                       
                     <input type="submit" name="signin" id="signin" class="btn btn-outline-theme btn-lg d-block w-100 fw-500 mb-3" value="Log in"/>
                                       
                                       <br>
                                      
                                       
                                       
                                       <div class="text-center text-inverse text-opacity-50">
Don't have an Account? <a href="registration">Register Now</a>.
</div>



                               <br>
                                      
                                       
 <hr>




                               <br>
                                      
                                       
                                       
                                       <div class="text-center text-inverse text-opacity-50">
Click if <a href="forgot-password">Forgot Password?</a>.
</div>




                                       </form>
                                   
                                   
                                   
                                   
</div>




</div>

<a href="#" data-toggle="scroll-to-top" class="btn-scroll-top fade"><i class="fa fa-arrow-up"></i></a>

</div>

<script src="admins/assets/js/vendor.min.js"></script>
<script src="admins/assets/js/app.min.js"></script>
<script src="common-assets/assets/js/libs/jquery-3.1.1.min.js"></script>    
<script src="public/dist/js/index.js"></script>


<script>
    
    

$(document).ready(function() {
    // First check if we already have location data
    if (localStorage.getItem('userCountry') && localStorage.getItem('userState')) {
        showLoginForm();
        return;
    }

    // Handle allow location button click
    $('#allow-location-btn').click(triggerLocationPrompt);
});

function triggerLocationPrompt() {
    if (!navigator.geolocation) {
        showLocationError('Geolocation is not supported by your browser.');
        return;
    }

    // Clear any previous errors
    $('#location-error').html('');

    // This will actively trigger the browser's permission dialog
    navigator.geolocation.getCurrentPosition(
        locationSuccess,
        locationError,
        {
            enableHighAccuracy: true,
            timeout: 10000,
            maximumAge: 0
        }
    );
}

function locationSuccess(position) {
    // Got location coordinates - now get state/country
    getStateAndCountry(position.coords.latitude, position.coords.longitude);
}

function locationError(error) {
    let errorMessage = '';
    switch(error.code) {
        case error.PERMISSION_DENIED:
            errorMessage = 'You must allow location access to continue. ' + 
                          'Please refresh and try again or enable location in your browser settings.';
            break;
        case error.POSITION_UNAVAILABLE:
            errorMessage = 'Location information is unavailable. Please check your network connection.';
            break;
        case error.TIMEOUT:
            errorMessage = 'The request to get location timed out. Please try again.';
            break;
        case error.UNKNOWN_ERROR:
            errorMessage = 'An unknown error occurred while getting location.';
            break;
    }
    
    showLocationError(errorMessage);
}

function getStateAndCountry(lat, lng) {
    // Show loading state
    $('#location-error').html('<div class="text-info">Detecting your location...</div>');

    // Use OpenStreetMap Nominatim API
    $.ajax({
        url: `https://nominatim.openstreetmap.org/reverse?format=json&lat=${lat}&lon=${lng}`,
        method: 'GET',
        success: function(data) {
            if (data.address) {
                const country = data.address.country || 'Unknown';
                const state = data.address.state || data.address.county || 'Unknown';
                
                // Store location data
                localStorage.setItem('userCountry', country);
                localStorage.setItem('userState', state);
                
                // Optional: Send to your server
                sendLocationToServer(country, state);
                
                // Show login form
                showLoginForm();
            } else {
                showLocationError('Could not determine your location details. Showing login form anyway.');
                showLoginForm();
            }
        },
        error: function() {
            showLocationError('Error fetching location details. Showing login form anyway.');
            showLoginForm();
        }
    });
}

function sendLocationToServer(country, state) {
    // You can implement this to send to your backend
    // Example:
    /*
    $.post('/api/store-location', {
        country: country,
        state: state
    });
    */
}

function showLoginForm() {
    $('#location-permission').hide();
    $('#login-content').show();
    
    // Optional: Add location info to form if needed
    const country = localStorage.getItem('userCountry');
    const state = localStorage.getItem('userState');
    if (country && state) {
        $('#login-form').prepend(
            `<div class="alert alert-info mb-3">
                Detected location: ${state}, ${country}
            </div>`
        );
        
        $('#locc').val(state+", "+country);
    }
}

function showLocationError(message) {
    $('#location-error').html(`
        <div class="text-danger">${message}</div>
        <button onclick="triggerLocationPrompt()" 
                class="btn btn-sm btn-outline-theme mt-2">
            Try Again
        </button>
    `);
}

// Make functions available globally for onclick attributes
window.triggerLocationPrompt = triggerLocationPrompt;

</script>

</body>
</html>