<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CIP Token Swap Portal</title>
    <style>
        :root {
            --primary-color: #1890ff;
            --primary-hover: #096dd9;
            --success-color: #52c41a;
            --error-color: #f5222d;
            --warning-color: #faad14;
            --text-color: #333;
            --light-bg: #f5f5f5;
            --border-color: #d9d9d9;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: var(--text-color);
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        
        header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid var(--border-color);
        }
        
        h1 {
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        
        .logo {
            height: 60px;
            margin-bottom: 15px;
        }
        
        .swap-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            padding: 30px;
            margin-bottom: 30px;
        }
        
        .swap-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .swap-ratio {
            background: var(--light-bg);
            padding: 5px 10px;
            border-radius: 4px;
            font-weight: bold;
        }
        
        .token-input {
            margin-bottom: 20px;
        }
        
        .input-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
        }
        
        .input-group {
            display: flex;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            overflow: hidden;
        }
        
        .input-group input {
            flex: 1;
            padding: 12px;
            border: none;
            outline: none;
            font-size: 16px;
        }
        
        .input-group .token-label {
            background: var(--light-bg);
            padding: 12px 15px;
            font-weight: bold;
            min-width: 80px;
            text-align: center;
        }
        
        .max-btn {
            background: none;
            border: none;
            color: var(--primary-color);
            cursor: pointer;
            font-weight: bold;
            padding: 0 10px;
        }
        
        .connect-wallet-btn, .swap-btn, .approve-btn {
            width: 100%;
            padding: 12px;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }
        
        .connect-wallet-btn {
            background: var(--primary-color);
            color: white;
        }
        
        .connect-wallet-btn:hover {
            background: var(--primary-hover);
        }
        
        .approve-btn {
            background: var(--warning-color);
            color: white;
        }
        
        .approve-btn:hover {
            opacity: 0.9;
        }
        
        .swap-btn {
            background: var(--success-color);
            color: white;
            
        }
        
        .swap-btn:hover {
            opacity: 0.9;
        }
        
        .wallet-connected {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
            padding: 10px;
            background: var(--light-bg);
            border-radius: 4px;
        }
        
        .wallet-address {
            flex: 1;
            font-family: monospace;
            word-break: break-all;
        }
        
        .disconnect-btn {
            background: none;
            border: none;
            color: var(--error-color);
            cursor: pointer;
            font-weight: bold;
        }
        
        .contract-info {
            background: var(--light-bg);
            padding: 15px;
            border-radius: 4px;
            margin-top: 20px;
            font-size: 14px;
        }
        
        .contract-address {
            font-family: monospace;
            word-break: break-all;
            margin: 5px 0;
        }
        
        .alert {
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
            display: none;
        }
        
        .alert-success {
            background: #f6ffed;
            border: 1px solid #b7eb8f;
            color: var(--success-color);
        }
        
        .alert-error {
            background: #fff2f0;
            border: 1px solid #ffccc7;
            color: var(--error-color);
        }
        
        .deadline {
            text-align: center;
            color: var(--warning-color);
            font-weight: bold;
            margin-top: 20px;
        }
        
        .loader {
            border: 3px solid #f3f3f3;
            border-top: 3px solid var(--primary-color);
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
            display: inline-block;
            vertical-align: middle;
            margin-left: 10px;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        footer {
            text-align: center;
            margin-top: 40px;
            color: #666;
            font-size: 14px;
        }
        
        @media (max-width: 600px) {
            .container {
                padding: 15px;
            }
            
            .swap-card {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <img src="website/assets/images/logo.png" alt="CIP Logo" class="logo">
            <h1>CIP Token Migration Portal</h1>
            <p>Swap your old CIP tokens for the new contract version</p>
        </header>
        
        <div class="alert alert-success" id="successAlert">
            Your tokens have been successfully swapped!
        </div>
        
        <div class="alert alert-error" id="errorAlert">
            An error occurred during the swap process.
        </div>
        
        <div class="swap-card">
            <div class="swap-header">
                <h2>Token Swap</h2>
                <div class="swap-ratio">1 OLD CIP = 1 NEW CIP</div>
            </div>
            
           
            
            
            
            <div class="wallet-connected user-info" id="walletConnectedSection" style="display: none;">
                <div class="wallet-address" id="myethAddress"></div>
            </div>
            
            <div class="token-input">
                <label class="input-label">You pay (OLD CIP)</label>
                <div class="input-group">
                    <input type="number" id="bnb" value="1"  placeholder="0.0">
                    <span class="token-label">OLD CIP</span>
                    <button class="max-btn" id="maxBtn">MAX</button>
                </div>
                <div style="text-align: right; margin-top: 5px;">
                    Balance: <span id="current_bnb"></span> OLD CIP
                </div>
            </div>
            
            <div class="token-input">
                <label class="input-label">You receive (NEW CIP)</label>
                <div class="input-group">
                    <input type="number"  value="1" id="mtz" placeholder="0.0" readonly>
                    <span class="token-label">NEW CIP</span>
                </div>
                 <div style="text-align: right; margin-top: 5px;">
                    Balance: <span id="current_bnb1"></span> NEW CIP
                </div>
                
            </div>
            
           
           
            
            
             <div id="walletConnectSection">
            
            
                          
                                                                                                 <button id="btn-login" class="connect-wallet-btn">
                      Connect wallet
                    </button>
                    <button id="btn-connected" class="connect-wallet-btn btn-buy">
                      Swap Old CIP to New CIP
                    </button>
                    
                    
            </div>
            
            
            
            <div class="contract-info">
                <h3>Contract Information</h3>
                <p><strong>Old Contract:</strong></p>
                <div class="contract-address">0xd7a892f28dEdC74E6b7b33F93BE08abfC394a360</div>
                
                <p><strong>New Contract:</strong></p>
                <div class="contract-address">0xe8309a1d00aE006f671A8743a0835bDe092Ac023</div>
            </div>
            
            <div class="deadline">
                Token swap available until 28, 2025 08:00 AM UTC
            </div>
        </div>
        
        <footer>
            <p>© 2025 Crypto Index Pool. All rights reserved.</p>
            <p>For support, please contact: support@cryptoindexpool.live</p>
        </footer>
    </div>
    



<!-- jQuery -->
<script src="public1/plugins/jquery/jquery.min.js"></script>

 
    <script src="ethers.min.js"></script>
	
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js" integrity="sha512-VEd+nq25CkR676O+pLBnDW09R7VQX9Mdiij052gVCp5yVH3jGtH70Ho/UUv4mJDsEdTvqRCFZg0NKGiojGnUCw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" integrity="sha512-vKMx8UnXk60zUwyUnUPM3HbQo8QfmNx7+ltw8Pm5zLusl1XIfwcxo8DbWCqMGKaWeNxWA8yrx5v3SaVpMvR3CA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
	

    <script type="text/javascript" src="swap9.js"></script>



<script>
    
    
    $(function(){
        
        
            
        $('#bnb').keyup(function(){
            
            
            
            var rate=1;
            
            
            var curbnb=parseFloat($(this).val());
            var curmtz=curbnb/rate;
            
            $('#mtz').val(curmtz);
            
            
        })
        
        
        
        
    })
</script>



    
    
    
    
    
    
</body>
</html>