<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<title>Our Stores</title>

	<meta name="keywords" content="" />
	<meta name="description" content="">
	<meta name="author" content="">

	<!-- Favicon -->
	<link rel="icon" type="image/x-icon" href="website/assets/images/icons/favicon.ico">

	<script type="text/javascript">
		WebFontConfig = {
			google: { families: [ 'Open+Sans:300,400,600,700,800','Poppins:300,400,500,600,700,800' ] }
		};
		(function(d) {
			var wf = d.createElement('script'), s = d.scripts[0];
			wf.src = 'website/assets/js/webfont.js';
			wf.async = true;
			s.parentNode.insertBefore(wf, s);
		})(document);
	</script>

	<!-- Plugins CSS File -->
	<link rel="stylesheet" href="website/assets/css/bootstrap.min.css">

	<!-- Main CSS File -->
	<link rel="stylesheet" href="website/assets/css/style.min.css">
	<link rel="stylesheet" type="text/css" href="website/assets/vendor/fontawesome-free/css/all.min.css">
</head>
<body>
	<div class="page-wrapper">
		
		
<?php
include(app_path().'/views/website-header.php');
?>


	<main class="main">
			<nav aria-label="breadcrumb" class="breadcrumb-nav">
				<div class="container">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="index"><i class="icon-home"></i></a></li>
						<li class="breadcrumb-item active" aria-current="page">Our Stores</li>
					</ol>
				</div>
			</nav>




				<div class="container pb-3">
				<div class="row">
					<div class="col-lg-12 ">
						<nav class="toolbox">
							<div class="toolbox-left">
								<div class="toolbox-item toolbox-sort">
									<label>Select State</label>

									<div class="select-custom">
										<select name="state" class="form-control">
											  <option value="">All State</option>
                <option >Delhi</option>
                    <option >Andaman & Nicobar Islands</option>
                    <option>Andhra Pradesh</option>
                    <option>Arunachal Pradesh</option>
                    <option>Assam</option>
                    <option>Bihar</option>
                    <option>Chhattisgarh</option>
                    <option>Dadra & Nagar Haveli</option>
                    <option>Daman & Diu</option>
                    
                    <option>Goa</option>
                    <option>Gujarat</option>
                    <option>Haryana</option>
                    <option>Himachal Pradesh</option>
                    <option>Jammu & Kashmir</option>
                    <option>Jharkhand</option>
                    <option>Karnataka</option>
                    <option>Kerala</option>
                    <option >Lakshadweep</option>
                    <option >Madhya Pradesh</option>
   <option >Maharashtra</option>
                    <option >Manipur</option>
                    <option >Meghalaya</option>
                    <option >Mizoram</option>
                    <option >Nagaland</option>
                    <option>Orissa</option>
                    <option>Pondicherry</option>
                    <option>Punjab</option>
                    <option>Rajasthan</option>
                    <option>Sikkim</option>


                    <option>Tamil Nadu</option>
   <option>Telangana</option>
                    <option>Tripura</option>
                    <option >Uttar Pradesh</option>
                    <option >Uttarakhand</option>
                                     <option>West Bengal</option>
										</select>
									</div><!-- End .select-custom -->

								</div><!-- End .toolbox-item -->
							</div><!-- End .toolbox-left -->

						


						</nav>

						<div class="row pb-4">
						
						
						<?php
						foreach($legal as $l){
						?>
						
							<div class="col-12 product-default left-details product-list mb-4">
								<figure>
									<a href="#">
										<img src="public/img/news/store.png">
									</a>
								</figure>
								<div class="product-details">
									
									<h2 class="product-title">
										<a href="#"><?php  echo($l->name);  ?></a>
									</h2>
									<div class="ratings-container">
										<div class="product-ratings">
											<span class="ratings" style="width:100%"></span><!-- End .ratings -->
											<span class="tooltiptext tooltip-top"></span>
										</div><!-- End .product-ratings -->
									</div><!-- End .product-container -->
								
								
									<div class="price-box">
										<span class="product-price" style="line-height: 1.8;">
										Address : <?php  echo($l->address);  ?><br>
									State : <?php  echo($l->state);  ?><br>
									Contact Number : <?php  echo($l->phone);  ?><br>
									Email Id : <?php  echo($l->email);  ?>
										
										</span>
									</div><!-- End .price-box -->
									
									
								</div><!-- End .product-details -->
							</div>
						

<?php
						}
?>


</div>

					



					</div><!-- End .col-lg-9 -->





	</div><!-- End .row -->
			</div><!-- End .container -->
	
			<div  style="display:none;"class="container mb-8">
				<div id="map"></div><!-- End #map -->

				<div class="row">
					<div class="col-md-8">
						<h2 class="light-title">Write <strong>Us</strong></h2>

						<form action="#">
							<div class="form-group required-field">
								<label for="contact-name">Name</label>
								<input type="text" class="form-control" id="contact-name" name="contact-name" required>
							</div><!-- End .form-group -->

							<div class="form-group required-field">
								<label for="contact-email">Email</label>
								<input type="email" class="form-control" id="contact-email" name="contact-email" required>
							</div><!-- End .form-group -->

							<div class="form-group">
								<label for="contact-phone">Phone Number</label>
								<input type="tel" class="form-control" id="contact-phone" name="contact-phone">
							</div><!-- End .form-group -->

							<div class="form-group required-field">
								<label for="contact-message">What’s on your mind?</label>
								<textarea cols="30" rows="1" id="contact-message" class="form-control" name="contact-message" required></textarea>
							</div><!-- End .form-group -->

							<div class="form-footer">
								<button type="submit" class="btn btn-primary">Submit</button>
							</div><!-- End .form-footer -->
						<input type="hidden" name="_token" value="<?php  echo csrf_token(); ?>">                   </form>
					</div><!-- End .col-md-8 -->

					<div class="col-md-4">
						<h2 class="light-title">Contact <strong>Details</strong></h2>

						<div class="contact-info">
							<div>
								<i class="icon-phone"></i>
								<p><a href="tel:">0201 203 2032</a></p>
								<p><a href="tel:">0201 203 2032</a></p>
							</div>
							<div>
								<i class="icon-mobile"></i>
								<p><a href="tel:">201-123-3922</a></p>
								<p><a href="tel:">302-123-3928</a></p>
							</div>
							<div>
								<i class="icon-mail-alt"></i>
								<p><a href="mailto:#">porto@gmail.com</a></p>
								<p><a href="mailto:#">porto@portotemplate.com</a></p>
							</div>
							<div>
								<i class="icon-skype"></i>
								<p>porto_skype</p>
								<p>porto_template</p>
							</div>
						</div><!-- End .contact-info -->
					</div><!-- End .col-md-4 -->
				</div><!-- End .row -->
			</div><!-- End .container -->
		</main><!-- End .main -->


<?php
include(app_path().'/views/website-footer.php');
?>




</div><!-- End .page-wrapper -->

<?php
include(app_path().'/views/website-footer2.php');
?>
	<!-- Plugins JS File -->
	<script src="website/assets/js/jquery.min.js"></script>
	<script src="website/assets/js/bootstrap.bundle.min.js"></script>
	<script src="website/assets/js/plugins.min.js"></script>

	<!-- Main JS File -->
	<script src="website/assets/js/main.min.js"></script>
</body>

</html>